% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vqsassess.R
\name{vqsassess}
\alias{vqsassess}
\title{Sequencing error and noise minimization, read down-sampling, and data preparation for viral quasispecies comparison}
\arguments{
\item{fasta}{Input as a read alignment in FASTA format}

\item{method}{Sequencing error and noise minimization methods that replace low frequency nucleotide base (less than the "pct" cut-off) with consensus base of that position ("conbase": default) or with base of the dominant haplotype ("domhapbase").}

\item{samplingfirst}{Downsampling before (TRUE) or after (FALSE: default) the noise minimization.}

\item{pct}{Percent cut-off defining low frequency nucleotide base that will be replaced (must be specified).}

\item{gappct}{The percent cut-off particularly specified for gap (-). If it is not specified or less than "pct", "gappct" will be equal to "pct" (default).}

\item{ignoregappositions}{Replace all nucleotides in the positions in the alignment containing gap(s) with gap. This will make such positions no longer single nucleotide variant (SNV). The default is "FALSE".}

\item{samsize}{Sample size (number of reads) after down-sampling. If it is not specified or more than number of reads in the original alignment, down-sampling will not be performed (default).}

\item{label}{String within quotation marks indicating name of read alignment (optional). Please don't use underscore (_) in the label.}
}
\value{
List of 1) "dat": viral quasispecies diversity metrics calculated by QSutils package (similar to "vqssub" function's output), 2) "snvhap": SNV profile of each haplotype with frequency and new label for "vqscompare" function, 3) "snv": plot of SNV frequency for "snvcompare" function, 4) "hapre": DNAStringSet of read alignment of each haplotype for "vqscompare" function, 5) "lab": name of sample or read alignment
}
\description{
Minimizes potential long-read sequencing error and noise based on the specified cut-off percentage of low frequency nucleotide base and down-samples read for further comparison with other samples. The output of this function is a list of several objects representing diversity of each sample that must be used as an input for other functions such as "snvcompare" or "vqscompare".
}
\examples{
## Locate input FASTA file------------------------------------------------------------------------
sample1filepath <- system.file("extdata", "s1.fasta", package = "longreadvqs")

## Prepare data for viral quasispecies comparison ------------------------------------------------
sample1 <- vqsassess(sample1filepath, pct = 10, samsize = 20, label = "sample1")

## For more examples on other choices of arguments, please see "vqssub" function's examples-------

}
