% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snvcompare.R
\name{snvcompare}
\alias{snvcompare}
\title{Plotting single nucleotide variant (SNV) frequency in read alignment across different samples}
\arguments{
\item{samplelist}{List of samples, i.e., name of resulting objects from "vqsassess" or "vqscustompct" functions, for example list(BC1, BC2, BC3).}

\item{ncol}{Number of columns for multiple plots (see cowplot's "plot_grid" function)}
}
\value{
Comparative plot of SNV frequency in read alignment across different samples
}
\description{
Compares single nucleotide variant (SNV) profile between noise-minimized down-sampled read samples using cowplot's "plot_grid" function. The resulting plot may help evaluating the optimal cut-off percentage of low frequency nucleotide base used in "vqsassess", "vqscustompct", or "vqssub" functions.
}
\examples{
## Locate input FASTA files-----------------------------------------------------------------------
sample1filepath <- system.file("extdata", "s1.fasta", package = "longreadvqs")
sample2filepath <- system.file("extdata", "s2.fasta", package = "longreadvqs")

## Prepare data for viral quasispecies comparison between two samples-----------------------------
sample1 <- vqsassess(sample1filepath, pct = 10, label = "sample1")
sample2 <- vqsassess(sample2filepath, pct = 10, label = "sample2")

## Compare SNV profile between two listed samples-------------------------------------------------
snvcompare(samplelist = list(sample1, sample2), ncol = 1)

}
