% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loopFuns.R
\name{annual_max}
\alias{annual_max}
\title{Compute Annual Maximum and Mean of On-the-Hour Records}
\usage{
annual_max(DF, record_attribute = "sea_level")
}
\arguments{
\item{DF}{A data.frame containing at least:
\itemize{
\item date: a Date or POSIXlt column of observation timestamps
\item a numeric column of values
}}

\item{record_attribute}{A character string giving the name of the column in DF containing the values.  Defaults to "sea_level".}
}
\value{
a data.frame containing a date column and a numeric column (specified in record_attribute) for years where at least one nonNA value is present, containing:
\itemize{
\item annMax - the annual maximum
\item annMean - the annual mean (calendar year)
\item datestr - the date/time of the annual maximum, formatted "YYYYmmddHH"
\item date - the POSIXlt timestamp of the annual maximum
\item pc_complete - the fraction (0 to 1) of hourly-timestamped samples available in that year
}
}
\description{
annual_max() takes a data frame of daily (or sub-daily) observations and returns a summary of the annual maximum and mean values, the date/time of each annual maximum, and the fraction of "on-the-hour" samples (data completeness) for each calendar year.
}
\details{
For each year, only observations exactly on the hour (minute == 0 & second == 0) are counted toward completeness.  If no valid data exist for a year, that year is dropped from the output.
}
\examples{
# generate example daily data
dates <- seq.Date(as.Date("1990-01-01"), as.Date("1995-12-31"), by = "day")
DF <- data.frame(
  date      = dates,
  sea_level = rnorm(length(dates), mean = 0, sd = 1)
)
# compute annual summary
am <- annual_max(DF)
head(am)

}
