% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simonBayesAnalysis}
\alias{simonBayesAnalysis}
\title{Analysis of Simon's Bayesian Basket Trials}
\usage{
simonBayesAnalysis(
  nstrata = NA_integer_,
  r = NA_real_,
  n = NA_real_,
  lambda = NA_real_,
  gamma = NA_real_,
  phi = NA_real_,
  plo = NA_real_
)
}
\arguments{
\item{nstrata}{The number of strata.}

\item{r}{The vector of number of responders across strata.}

\item{n}{The vector of number of subjects across strata.}

\item{lambda}{The prior probability that the drug activity is
homogeneous across strata.}

\item{gamma}{The prior probability that the drug is active in a
stratum.}

\item{phi}{The response probability for an active drug.}

\item{plo}{The response probability for an inactive drug.}
}
\value{
A list containing the following five components:
\itemize{
\item \code{case}: The matrix with each row corresponding to a combination
of drug activity over strata represented by the columns.
\item \code{prior_case}: The vector of joint prior probabilities
for the stratum-specific response rates.
\item \code{prior_stratum}: The vector of marginal prior probabilities
for the stratum-specific response rates.
\item \code{post_case}: The vector of joint posterior probabilities
for the stratum-specific response rates.
\item \code{post_stratum}: The vector of marginal posterior probabilities
for the stratum-specific response rates.
}
}
\description{
Obtains the prior and posterior probabilities for
Simon's Bayesian basket discovery trials.
}
\examples{

a = simonBayesAnalysis(
  nstrata = 10,
  r = c(8,0,1,1,6,2,0,0,3,3),
  n = c(19,10,26,8,14,7,8,5,4,14),
  lambda = 0.5, gamma = 0.33,
  phi = 0.35, plo = 0.15)

a$post_stratum

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
