% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LUE_BIOMASS_VPD.r
\name{LUE_BIOMASS_VPD}
\alias{LUE_BIOMASS_VPD}
\title{Light Use Efficiency Model to Estimate Biomass with Vapour Pressure Deficit}
\format{A Biomass raster}
\usage{
LUE_BIOMASS_VPD(fpar_raster,par,tmin,tmax,tdew,
tmin_min,tmin_max,vpd_max, vpd_min,LUE_optimal)
}
\arguments{
\item{fpar_raster}{fraction of photosynthetically active radiation (fpar) per day raster with .tif format}

\item{par}{clear sky surface photosynthetically active radiation (par) per day raster with .nc file format.}

\item{tmin}{Minimum temperature at 2 metres since previous post-processing per day raster with .nc file format.}

\item{tmax}{Maximum temperature at 2 metres since previous post-processing per day raster with .nc file format.}

\item{tdew}{Dewpoint temperature at 2 metres since previous post-processing per day raster with .nc file format.}

\item{tmin_min}{minimum value of tmin used for the threshold}

\item{tmin_max}{maximum value of tmin used for the threshold}

\item{vpd_max}{maximum value of vapour pressure deficit used for the threshold}

\item{vpd_min}{minimum value of vapour pressure deficit used for the threshold}

\item{LUE_optimal}{optical lue value with respect to crop type for example wheat crop LUE_optimal is 3.0 (Djumaniyazova et al., 2010)}
}
\value{
Biomass raster
}
\description{
LUE_BIOMASS_VPD() to estimate aboveground biomass firstly by calculating the Absorbed Photosynthetically Active Radiation (APAR) and secondly the actual values of light use efficiency by including vapour pressure deficit of the crops Shi et al.(2007) <doi:10.2134/agronj2006.0260>.
}
\examples{
\dontrun{
## load the data
data(fpar)
data(par1)
data(tmin)
data(tmax)
data(tdew)
LUE_BIOMASS_VPD(fpar,par1,tmin,tmax,tdew,-2,12,1.5,4,3)
}
library(raster)
fparr <- raster(nc=2, nr=2)
values(fparr)<-runif(ncell(fparr),min =0.2,max= 0.8)
par11<- brick(nc=2, nr=2, nl=2)
values(par11)<-runif(ncell(par11),min =169076.9,max= 924474.6)
tminn <- brick(nc=2, nr=2, nl=2)
values(tminn)<-runif(ncell(tminn),min = 278,max= 281)
tmaxx <- brick(nc=2, nr=2, nl=2)
values(tmaxx)<-runif(ncell(tmaxx),min = 278,max= 281)
tdeww <- brick(nc=2, nr=2, nl=2)
values(tdeww)<-runif(ncell(tdeww),min = 278,max= 281)
LUE_BIOMASS_VPD(fparr,par11,tminn,tmaxx,tdeww,-2,12,1.5,4,3)
}
\references{
Djumaniyazova Y, Sommer R, Ibragimov N, Ruzimov J, Lamers J & Vlek P (2010) Simulating water use and N response of winter wheat in the irrigated floodplains of Northwest Uzbekistan. Field Crops Research 116, 239-251.

Shi Z, Ruecker G R,Mueller M, Conrad C, Ibragimov N, Lamers J P A, Martius C, Strunz G, Dech S & Vlek P L G (2007) Modeling of Cotton Yields in the Amu Darya River Floodplains of Uzbekistan Integrating Multitemporal Remote Sensing and Minimum Field Data. Agronomy Journal 99, 1317-1326.
}
\keyword{datasets}
