% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lunar.package.R
\name{lunar.illumination}
\alias{lunar.illumination}
\title{Lunar Illumination}
\usage{
lunar.illumination(x, shift = 0)
}
\arguments{
\item{x}{A vector of \code{\link[base]{Date}} values.}

\item{shift}{The number of hours by which to shift the calculation of lunar phase.
By default lunar phase is calculated at 12 noon UT.}
}
\description{
Returns the proportion of lunar illumination on specified dates.
}
\details{
Adapted from function 
  \code{moon.illumination} in from the
  R4MFCL project (not an R package), which was developed
  by the Secretariat of the Pacific Community (SPC).
  The R4MFCL project was led by Simon Hoyle, and also includes code
  by Shelton Harley, Nick Davies, and Adam Langley of the SPC,
  and Pierre Kleiber of the US National Marine Fisheries Service.
  Pierre Kleiber is the author of the
  \code{moon.illumination} function.

  Code from project R4MFCL is distributed under the MIT License:

    \url{https://opensource.org/licenses/mit-license.php}

  Here is a link to the R4MFCL project:

    \url{https://code.google.com/archive/p/r4mfcl/}
}
\examples{
lunar.illumination(as.Date("2004-03-24"))
}
\seealso{
\code{\link{lunar.illumination.mean}}

\url{https://stackoverflow.com/questions/71757462/calculate-lunar-illumination-using-the-lunar-package-in-r}
}
\keyword{illumination}
\keyword{light}
\keyword{lunar}
\keyword{moon}
