% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abort.R
\name{abort_no_method_for_class}
\alias{abort_no_method_for_class}
\title{Abort method if class is not implemented}
\usage{
abort_no_method_for_class(fun, class, ...)
}
\arguments{
\item{fun}{A character vector with the function name.}

\item{class}{A character vector with the class name.}

\item{...}{Extra message to be added to the error message. Must be
character string.}
}
\value{
Returns an error condition of class \code{error_no_method_for_class}.
}
\description{
Creates a custom error condition created with
\code{\link[rlang:abort]{rlang::abort()}} with a - hopefully - more useful
error message and metadata.
}
\seealso{
\code{\link[=abort_argument_type]{abort_argument_type()}},
\code{\link[=abort_argument_class]{abort_argument_class()}},
\code{\link[=abort_argument_length]{abort_argument_length()}},
\code{\link[=abort_argument_diff_length]{abort_argument_diff_length()}},
\code{\link[=abort_column_not_found]{abort_column_not_found()}},
\code{\link[=abort_package_not_installed]{abort_package_not_installed()}}
}
