% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify.R
\name{classify}
\alias{classify}
\title{Classify Cognitive Function Based on Total Scores}
\usage{
classify(data)
}
\arguments{
\item{data}{A dataframe containing cognitive test scores, including total immediate word recall, delayed word recall,
serial subtraction, and backwards counting scores.}
}
\value{
A dataframe with:
\itemize{
\item \code{Total_cog_score}: Total cognitive score (sum of all individual task scores).
\item \code{Class}: Cognitive function classification (1 = Normal, 2 = Cognitive impairment no dementia, 3 = Demented).
\item Renamed columns with updated labels for 2022 data: \code{imrc_imp2022}, \code{dlrc_imp2022},
\code{ser7_imp2022}, \code{bwc20_imp2022}, \code{cogtot27_imp2022}, and \code{cogfunction2022}.
}
}
\description{
This function classifies individuals into cognitive function groups based on their total cognition score,
which is calculated from immediate word recall, delayed word recall, serial subtraction, and backwards counting scores.
The classification creates three categories of cognitive function.
}
\details{
The function creates a total cognitive score by summing the scores for immediate word recall, delayed word recall,
serial subtraction, and backwards counting. It then classifies the cognitive function into three levels:
\itemize{
\item Class 1: Normal (total score >= 12).
\item Class 2: Cognitive impairment no dementia (total score between 7 and 11).
\item Class 3: Demented (total score <= 6).
}
}
\examples{
# Assuming `cog_data` is a dataframe with the relevant columns
classified_data <- classify(cog_data_score)

}
