% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_provider.R, R/url_utils.R
\name{get_provider}
\alias{get_provider}
\title{Determine provider from model name}
\usage{
get_provider(model)

get_provider(model)
}
\arguments{
\item{model}{Model identifier}
}
\value{
Character string with the provider name

Provider name
}
\description{
This function determines the appropriate provider (e.g., OpenAI, Anthropic, Google, OpenRouter) based on the model name.

This is a helper function that extracts the provider name from a model identifier.
It's used internally to determine which base_url to use from a list of provider-specific URLs.
}
\details{
Supported providers and models include:
\itemize{
\item OpenAI: 'chatgpt-4o-latest', 'gpt-3.5-turbo', 'gpt-4', 'gpt-4-turbo', 'gpt-4.1', 'gpt-4.1-mini', 'gpt-4.1-nano', 'gpt-4o', 'gpt-4o-mini', 'gpt-5', 'gpt-5-mini', 'gpt-5-nano', 'o1', 'o1-mini', 'o1-pro', 'o3', 'o3-mini', 'o4-mini' and more with date variants
\item Anthropic: 'claude-opus-4-1-20250805', 'claude-opus-4-20250514', 'claude-sonnet-4-20250514', 'claude-3-7-sonnet-20250219', 'claude-3-5-sonnet-20241022', 'claude-3-5-haiku-20241022', 'claude-3-opus-20240229'
\item DeepSeek: 'deepseek-chat', 'deepseek-reasoner'
\item Google: 'gemini-2.5-pro', 'gemini-2.5-flash', 'gemini-2.0-flash', 'gemini-2.0-flash-lite', 'gemini-1.5-pro-latest', 'gemini-1.5-flash-latest', 'gemini-1.5-flash-8b'
\item Qwen: 'qwen-max-2025-01-25', 'qwen3-72b'
\item Stepfun: 'step-2-mini', 'step-2-16k', 'step-1-8k'
\item Zhipu: 'glm-4-plus', 'glm-3-turbo'
\item MiniMax: 'minimax-text-01'
\item Grok: 'grok-3', 'grok-3-latest', 'grok-3-fast', 'grok-3-fast-latest', 'grok-3-mini', 'grok-3-mini-latest', 'grok-3-mini-fast', 'grok-3-mini-fast-latest'
\item OpenRouter: Provides access to models from multiple providers through a single API. Format: 'provider/model-name'
\itemize{
\item OpenAI models: 'openai/gpt-4o', 'openai/gpt-4o-mini', 'openai/gpt-4-turbo', 'openai/gpt-4', 'openai/gpt-3.5-turbo'
\item Anthropic models: 'anthropic/claude-opus-4.1', 'anthropic/claude-opus-4', 'anthropic/claude-sonnet-4', 'anthropic/claude-3.7-sonnet',
'anthropic/claude-3.5-sonnet', 'anthropic/claude-3.5-haiku', 'anthropic/claude-3-opus'
\item Meta models: 'meta-llama/llama-3-70b-instruct', 'meta-llama/llama-3-8b-instruct', 'meta-llama/llama-2-70b-chat'
\item Google models: 'google/gemini-2.5-pro', 'google/gemini-2.5-flash', 'google/gemini-2.0-flash', 'google/gemini-1.5-pro-latest', 'google/gemini-1.5-flash'
\item Mistral models: 'mistralai/mistral-large', 'mistralai/mistral-medium', 'mistralai/mistral-small'
\item Qwen models: 'qwen/qwen3-coder:free', 'qwen/qwen3-235b-a22b-07-25:free', 'qwen/qwen2.5-72b-instruct:free'
\item DeepSeek models: 'deepseek/deepseek-r1:free', 'tngtech/deepseek-r1t2-chimera:free'
\item Other models: 'microsoft/mai-ds-r1:free', 'moonshotai/kimi-k2:free', 'tencent/hunyuan-a13b-instruct:free'
}
}
}
\keyword{internal}
