% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_model_predictions.R
\name{standardize_cell_type_names}
\alias{standardize_cell_type_names}
\title{Standardize cell type names using a language model}
\usage{
standardize_cell_type_names(
  predictions,
  models,
  api_keys,
  standardization_model = "claude-sonnet-4-20250514"
)
}
\arguments{
\item{predictions}{List of predictions from different models}

\item{models}{Vector of model names that successfully completed predictions}

\item{api_keys}{Named list of API keys. Can be provided in two formats:
\enumerate{
\item With provider names as keys: \code{list("openai" = "sk-...", "anthropic" = "sk-ant-...", "openrouter" = "sk-or-...")}
\item With model names as keys: \code{list("gpt-4o" = "sk-...", "claude-3-opus" = "sk-ant-...")}
}}

\item{standardization_model}{Model to use for standardization (default: "claude-sonnet-4-20250514")}
}
\value{
List of standardized predictions with the same structure as the input
}
\description{
This function takes predictions from multiple models and standardizes the cell type
nomenclature to ensure consistent naming across different models' outputs.
}
\keyword{internal}
