% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve-special.R
\name{retrieve_SpecialCases}
\alias{retrieve_SpecialCases}
\alias{retrieveTemplate}
\alias{retrieveModels}
\alias{retrieveIds}
\alias{retrieveAttributes}
\alias{retrieveParentName}
\title{Helper functions that utilize special cases of magma /retrieve}
\usage{
retrieveTemplate(target, projectName, ...)

retrieveModels(target, projectName, template = NULL, ...)

retrieveIds(target, projectName, modelName, ...)

retrieveAttributes(target, projectName, modelName, ...)

retrieveParentName(target, projectName, modelName, template = NULL, ...)
}
\arguments{
\item{target}{A list, which can be created using \code{\link{magmaRset}}, containing your authorization 'token' (a string), a 'url' of magma to target (a string), and optional 'opts' for specifying additions parameters for curl requests (a named list).}

\item{projectName}{Single string. The name of the project you would like to interact with. For options, see \code{\link{retrieveProjects}}.}

\item{...}{Additional parameters passed along to the internal `.retrieve()`, `.query()`, or `.update()` functions,
for troubleshooting or advanced-user purposes only: \itemize{
\item \code{request.only} (Logical) & \code{json.params.only} (Logical) which 1) stop the function before its main curl request to magma and 2) returns the values that would have been sent to magma in either of two formats.
\item \code{verbose} (Logical) sets whether to report the status of the curl request after it is performed.
}}

\item{template}{For internal use in minimizing excess http requests to magma, NULL or the return of \code{retrieveTemplate(target, projectName)}.}

\item{modelName}{Single string. The name of the subset data structure within the project, which are referred to as 'model's in magma, to interact with.
For options, see \code{\link{retrieveModels}} or https://timur.ucsf.edu/<projectName>/map.}
}
\value{
retrieveTemplate = a list conversion of the project's template json.

retrieveModels = a string vector of model names

retrieveIds = a string vector of record names/identifiers.

retrieveAttributes = a string vector of attribute names.
}
\description{
Helper functions that utilize special cases of magma /retrieve
}
\details{
These functions aim to help users determine acceptable inputs to other magmaR functions without needing to leave R.

They make properly crafted calls to \code{\link{retrieve}} which target either the "template" or "identifier" special cases outlined in \url{https://mountetna.github.io/magma.html#retrieve},
followed by directly returning the output (\code{retrieveTemplate} and \code{retrieveIds}),
by returning just a targeted portion of that output (\code{retrieveModels}),
or by returning a targeted portion of a subsequent single-record call to \code{\link{retrieve}} (\code{retrieveAttributes}).
}
\section{Functions}{
\itemize{
\item \code{retrieveTemplate()}: Retrieve the template for a given project

\item \code{retrieveModels()}: Retrieve the modelNames for a given project

\item \code{retrieveIds()}: Retrieve all the identifiers/recordNames for a given project-model pair.

\item \code{retrieveAttributes()}: Retrieve all the attribute options for a given project-model pair.

\item \code{retrieveParentName()}: Retrieve the parent modelName / attributeName for a given project-model pair.

}}
\examples{

if (interactive()) {
    # First, we use magmaRset to create an object which will tell other magmaR
    #  functions our authentication token (as well as some other optional bits).
    # When run in this way, it will ask you to give your token.
    magma <- magmaRset()
    
    template <- retrieveTemplate(
        target = magma,
        projectName = "example")
    str(template, max.level = 4)
        
    models <- retrieveModels(
        target = magma,
        projectName = "example")
    print(models)    

    ids <- retrieveIds(
        target = magma,
        projectName = "example",
        modelName = "rna_seq")
    print(ids)
        
    atts <- retrieveAttributes(
        target = magma,
        projectName = "example",
        modelName = "subject")
    print(atts)
}
}
