% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieveMetadata.R
\name{retrieveMetadata}
\alias{retrieveMetadata}
\title{Download data from magma of one model, but transformed into the shape of a different model's records.}
\usage{
retrieveMetadata(
  target,
  projectName,
  meta_modelName,
  meta_attributeNames = "all",
  target_modelName,
  target_recordNames = "all",
  template = NULL,
  ...
)
}
\arguments{
\item{target}{A list, which can be created using \code{\link{magmaRset}}, containing your authorization 'token' (a string), a 'url' of magma to target (a string), and optional 'opts' for specifying additions parameters for curl requests (a named list).}

\item{projectName}{Single string. The name of the project you would like to interact with. For options, see \code{\link{retrieveProjects}}.}

\item{meta_modelName, meta_attributeNames}{Strings which indicate the "meta"data to retrieve.
They work the same as inputs of other functions without the \code{meta_} portion.}

\item{target_modelName, target_recordNames}{Strings which indicate the "target" data that meta-data is desired to be reshaped into.
They work the same as inputs of other functions without the \code{target_} portion, and
these inputs ultimately set which records of "meta" model data to actually obtain.}

\item{template}{For internal use in minimizing excess http requests to magma, NULL or the return of \code{retrieveTemplate(target, projectName)}.}

\item{...}{Additional parameters passed along to the internal `.retrieve()`, `.query()`, or `.update()` functions,
for troubleshooting or advanced-user purposes only: \itemize{
\item \code{request.only} (Logical) & \code{json.params.only} (Logical) which 1) stop the function before its main curl request to magma and 2) returns the values that would have been sent to magma in either of two formats.
\item \code{verbose} (Logical) sets whether to report the status of the curl request after it is performed.
}}
}
\value{
A dataframe with rows = \code{target_recordNames} and columns = model identifiers and either \code{meta_attributeNames} or repeats of \code{meta_attributeNames_#} when there are 1:many mappings of target data records to metadata records.
}
\description{
Retrieve data from one model ("meta") transformed into the shape of linked records of a different model ("target").
For example, one could get subject-level information for an RNAseq counts matrix with this function.
The output would contain columns of subject-level attributes, and rows that are the RNAseq-model records.
}
\details{
This function retrieves data from one model (the "meta" model) transformed so that rows of the returned dataframe correspond to records of a different model (the "target" model).

Internally, it first determines the path, through child-parent model linkages, to navigate from the meta_model to the target_model.

Then, it performs calls to \code{\link{query}} in order to retrieve identifier linkage along that path.
The identifier linkage is turned into a dataframe of identifier traces.

Next, it performs a call to \code{\link{retrieve}} to obtain the wanted metadata as a dataframe.

(If linkage paths would create any 1:many mappings of target data records to metadata records, data of extra records are shifted "rightwards" into columns appended with "_#" in their names.
This is a reliable, though imperfect, method so we hope to implement alternatives in the future.)

Finally, the dataframe of linkage path identifiers is merged with the metadata dataframe, reshaping the metadata to properly have one row per requested \code{target_recordName}.
}
\examples{

if (interactive()) {
    # First, we use magmaRset to create an object which will tell other magmaR
    #  functions our authentication token (as well as some other optional bits).
    # When run in this way, it will ask you to give your token.
    magma <- magmaRset()
    
    # Running like this will ask for input of your janus token one time.
    retrieveMetadata(
        target = magma,
        projectName = "example",
        meta_modelName = "subject",
        meta_attributeNames = "group",
        target_modelName = "rna_seq",
        target_recordNames = "all")
}

}
\seealso{
\code{\link{retrieve}} and \code{\link{retrieveMatrix}} which will likely be useful for retrieving associated "target" data.
}
