% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_km.R
\name{basic_kmplot}
\alias{basic_kmplot}
\title{Basic Kaplan Meier (KM) plot function}
\usage{
basic_kmplot(
  kmdat,
  endpoint_name = "Time to Event Endpoint",
  time_scale = NULL,
  time_grid = NULL,
  show_risk_set = TRUE,
  main_title = "Kaplan-Meier Curves",
  subplot_heights = NULL,
  suppress_plot_layout = FALSE,
  use_colors = NULL,
  use_line_types = NULL,
  use_pch_cex = 0.65,
  use_pch_alpha = 100
)
}
\arguments{
\item{kmdat}{a \code{data.frame}, must consist \code{treatment}, \code{time} (unit in days), \code{n.risk}, \code{censor}, \code{surv}, similar to
an output from \code{maicplus:::survfit_makeup}}

\item{endpoint_name}{a string, name of time to event endpoint, to be show in the last line of title}

\item{time_scale}{a string, time unit of median survival time, taking a value of 'years', 'months', 'weeks' or 'days'}

\item{time_grid}{a numeric vector in the unit of \code{time_scale}, risk set table and x axis of the km plot will be
defined based on this time grid}

\item{show_risk_set}{logical, show risk set table or not, TRUE by default}

\item{main_title}{a string, main title of the KM plot}

\item{subplot_heights}{a numeric vector, heights argument to \code{graphic::layout()},NULL by default which means
user will use the default setting}

\item{suppress_plot_layout}{logical, suppress the layout setting in this function so that user can specify layout
outside of the function, FALSE by default}

\item{use_colors}{a character vector of length up to 4, colors to the KM curves, it will be passed to \code{col} of
\code{lines()}}

\item{use_line_types}{a numeric vector of length up to 4, line type to the KM curves, it will be passed to \code{lty} of
\code{lines()}}

\item{use_pch_cex}{a scalar between 0 and 1, point size to indicate censored individuals on the KM curves, it will be
passed to \code{cex} of \code{points()}}

\item{use_pch_alpha}{a scalar between 0 and 255, degree of color transparency of points to indicate censored
individuals on the KM curves, it will be passed to \code{cex} of \code{points()}}
}
\value{
a KM plot with or without risk set table appended at the bottom, with up to 4 KM curves
}
\description{
This function can generate a basic KM plot with or without risk set table appended at the bottom. In a single plot,
it can include up to 4 KM curves. This depends on number of levels in 'treatment' column in the input data.frame
\code{kmdat}
}
\examples{
library(survival)
data(adtte_sat)
data(pseudo_ipd_sat)

combined_data <- rbind(adtte_sat[, c("TIME", "EVENT", "ARM")], pseudo_ipd_sat)
kmobj <- survfit(Surv(TIME, EVENT) ~ ARM, combined_data, conf.type = "log-log")
kmdat <- do.call(rbind, survfit_makeup(kmobj))
kmdat$treatment <- factor(kmdat$treatment)

# without risk set table
basic_kmplot(kmdat,
  time_scale = "month",
  time_grid = seq(0, 20, by = 2),
  show_risk_set = FALSE,
  main_title = "Kaplan-Meier Curves",
  subplot_heights = NULL,
  suppress_plot_layout = FALSE,
  use_colors = NULL,
  use_line_types = NULL
)

# with risk set table
basic_kmplot(kmdat,
  time_scale = "month",
  time_grid = seq(0, 20, by = 2),
  show_risk_set = TRUE,
  main_title = "Kaplan-Meier Curves",
  subplot_heights = NULL,
  suppress_plot_layout = FALSE,
  use_colors = NULL,
  use_line_types = NULL
)
}
