% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{count_haplotype_occurrences_pedigree}
\alias{count_haplotype_occurrences_pedigree}
\title{Count haplotypes occurrences in pedigree}
\usage{
count_haplotype_occurrences_pedigree(
  pedigree,
  haplotype,
  generation_upper_bound_in_result = -1L
)
}
\arguments{
\item{pedigree}{Pedigree to count occurrences in.}

\item{haplotype}{Haplotype to count occurrences of.}

\item{generation_upper_bound_in_result}{Only consider matches in
generation 0, 1, ... generation_upper_bound_in_result.
-1 means disabled, consider all generations.
End generation is generation 0.
Second last generation is 1.
And so on.}
}
\value{
Number of times that \code{haplotype} occurred in \code{pedigree}.
}
\description{
Counts the number of types \code{haplotype} appears in \code{pedigree}.
}
\seealso{
\code{\link[=pedigree_haplotype_matches_in_pedigree_meiosis_L1_dists]{pedigree_haplotype_matches_in_pedigree_meiosis_L1_dists()}}.
}
