% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixtbern.R
\name{mixtbern}
\alias{mixtbern}
\title{Single allocation clustering in networks}
\usage{
mixtbern(y, K = 4, maxT = 5000, seed = 1, verbose = FALSE)
}
\arguments{
\item{y}{A n x d actor-event adjacency matrix, whereby y_ij is 1 if actor i attended event j -- 0 otherwise.}

\item{K}{Number of single clusters. Default is set to 4.}

\item{maxT}{Number of MCMC iterations. Default is set to 5000.}

\item{seed}{Random seed. Default is 1.}

\item{verbose}{Set to TRUE if you want to see the steps of the MCMC iterations. Defaults is FALSE.}
}
\value{
A manet object consisting of a list with five outputs:
\itemize{
\item{p.allocation.chain}{ A maxT x n x K array with the posterior probabilities of allocation to the heir clusters.}
\item{p.event.chain}{ A maxT x K x d array with the cluster - posterior probabilities of attendance to events.}
\item{p.community.chain}{ A maxT x K matrix with the heir cluster proportions.}
\item{adj} {The original adjacency matrix.}
\item{proc.time}{ The computational time.}
}
}
\description{
This function infers K single allocation cluster for actor-event network data.
}
\examples{
data(deepsouth)
ds<-mixtbern(deepsouth,K=2,maxT=100)
plot(ds)
summary(ds)
}
\keyword{actor-event,}
\keyword{mixture}
\keyword{models,}
\keyword{networks}
