% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_io_functions.R
\name{save_plot}
\alias{save_plot}
\title{Save Plot}
\usage{
save_plot(
  plot,
  file_path,
  width = 11,
  height = 6,
  dpi = 300,
  units = "in",
  device = NULL
)
}
\arguments{
\item{plot}{ggplot object. Plot to save}

\item{file_path}{Character. Output file path}

\item{width}{Numeric. Plot width in inches (default: 11)}

\item{height}{Numeric. Plot height in inches (default: 6)}

\item{dpi}{Numeric. Resolution in dots per inch (default: 300)}

\item{units}{Character. Units for width and height (default: "in")}

\item{device}{Character. Output device (auto-detected from file extension)}
}
\value{
Character. Path to saved file
}
\description{
Save ggplot object to file with publication-quality settings
}
\examples{
\donttest{
# Create a simple plot for demonstration
library(ggplot2)
p <- ggplot(mtcars, aes(x = mpg, y = hp)) + geom_point()

# Save with default settings (300 DPI, 11x6 inches)
save_plot(p, file.path(tempdir(), "test_plot.png"))

# Save with custom dimensions for presentation
save_plot(p, file.path(tempdir(), "presentation_plot.png"), width = 16, height = 9)

# Save as PDF for publication
save_plot(p, file.path(tempdir(), "publication_figure.pdf"), width = 8, height = 6)
}
}
