% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{ison_adolescents}
\alias{ison_adolescents}
\title{One-mode subset of the adolescent society network (Coleman 1961)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> -- # The Adolescent Society ----------------------------------------------------
#> # A labelled, undirected network of 8 adolescents and 10 friendships ties
#> 
#> -- Nodes
#> # A tibble: 8 x 1
#>   name 
#>   <chr>
#> 1 Betty
#> 2 Sue  
#> 3 Alice
#> 4 Jane 
#> 5 Dale 
#> 6 Pam  
#> # i 2 more rows
#> 
#> -- Ties
#> # A tibble: 10 x 2
#>    from    to
#>   <int> <int>
#> 1     1     2
#> 2     2     3
#> 3     3     4
#> 4     2     5
#> 5     3     5
#> 6     4     5
#> # i 4 more rows
#> 
}\if{html}{\out{</div>}}
}
\usage{
data(ison_adolescents)
}
\description{
One-mode subset of Coleman's adolescent society network (Coleman 1961),
as used in Feld's (1991) "Why your friends have more friends than you do".
Coleman collected data on friendships among students in 12 U.S. high schools.
Feld explored a subset of 8 girls from one of these schools, "Marketville",
and gave them fictitious names, which are retained here.
}
\references{
Coleman, James S. 1961. \emph{The Adolescent Society}.
New York: Free Press.

Feld, Scott. 1991. “Why your friends have more friends than you do”
\emph{American Journal of Sociology} 96(6): 1464-1477.
\doi{10.1086/229693}.
}
\keyword{datasets}
