% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_legend.R
\name{add_legend}
\alias{add_legend}
\title{Add Legend}
\usage{
add_legend(map, legend, layer_id)
}
\arguments{
\item{map}{a mapdeck map object}

\item{legend}{either a logical indiciating if the legend(s) should be displayed, or
a named list indicating which colour attributes should be included in the legend.}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type. Layers with the same id are likely
to conflict and not plot correctly}
}
\description{
Add a custom legend to the map
}
\examples{

\donttest{
sf <- spatialwidget::widget_melbourne
sf$my_colour <- ifelse( substr(sf$SA2_NAME, 1, 1) == "A", "#00FF00FF", "#FF0000FF")

l1 <- legend_element(
	variables = c("Begins with A", "Doesn't begin with A")
	, colours = c("#00FF00FF", "#FF0000FF")
	, colour_type = "fill"
	, variable_type = "category"
)
js <- mapdeck_legend(l1)

set_token( "MAPBOX_TOKEN" )
mapdeck() \%>\%
  add_legend(legend = js, layer_id = "my_layer")


mapdeck() \%>\%
  add_legend(legend = js, layer_id = "my_layer") \%>\%
  clear_legend(layer_id = "my_layer")

}

}
