% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend.R, R/map_legend.R
\name{clear_legend}
\alias{clear_legend}
\title{Clear Legend}
\usage{
clear_legend(map, layer_id)

clear_legend(map, layer_id)
}
\arguments{
\item{map}{the map from which you want to clear the legend.}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type. Layers with the same id are likely
to conflict and not plot correctly}
}
\description{
Clears the legend for a given layer_id

Removes a legend from the map
}
\examples{
\donttest{

sf <- spatialwidget::widget_melbourne
sf$my_colour <- ifelse( substr(sf$SA2_NAME, 1, 1) == "A", "#00FF00FF", "#FF0000FF")

l1 <- legend_element(
	variables = c("Begins with A", "Doesn't begin with A")
	, colours = c("#00FF00FF", "#FF0000FF")
	, colour_type = "fill"
	, variable_type = "category"
)
js <- mapdeck_legend(l1)

set_token( "MAPBOX_TOKEN" )

## Add a legend
mapdeck() \%>\%
  add_legend(legend = js, layer_id = "my_layer")

## Calling `clear_legend` should immediately remove it
mapdeck() \%>\%
  add_legend(legend = js, layer_id = "my_layer") \%>\%
  clear_legend(layer_id = "my_layer")

}

}
