% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gfw_emissions.R
\name{gfw_emissions}
\alias{gfw_emissions}
\alias{get_gfw_emissions}
\title{Forest greenhouse gas emissions}
\source{
\url{https://data.globalforestwatch.org/datasets/gfw::forest-greenhouse-gas-emissions/about}
}
\usage{
get_gfw_emissions()
}
\value{
A function that returns an \code{sf} footprint object.
}
\description{
This resource is part of the publication by Harris et al. (2021)
"Global maps of twenty-first century forest carbon fluxes.". It
represents "the greenhouse gas
emissions arising from stand-replacing forest disturbances that occurred in
each modelled year (megagrams CO2 emissions/ha, between 2001 and 2023).
Emissions include all relevant ecosystem carbon pools (aboveground biomass,
belowground biomass, dead wood, litter, soil) and greenhouse gases (CO2, CH4,
N2O)." The area unit that is downloaded here corresponds to the
"megagrams of CO2 emissions/pixel" layer, in order to support the calculation
of area-wise emissions.
}
\details{
There are no arguments users need to specify. However, users should note
that the spatial extent for this dataset does not totally cover the same
extent as the \code{treecover2000} and \code{lossyear} resources by Hansen
et al. (2013). A missing value (NA) will be inserted for greenhouse gas
emissions for areas where no data is available.
}
\references{
Harris, N.L., Gibbs, D.A., Baccini, A. et al. Global maps of
twenty-first century forest carbon fluxes. Nat. Clim. Chang. 11, 234–240
(2021). \doi{doi:10.1038/s41558-020-00976-6}
}
\keyword{resource}
