% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Michela}
\alias{Michela}
\title{Movement track of Michela, a roe deer}
\format{Data frame containing movements of roe deer with the following columns:
\describe{
  \item{id}{ID of animal}
  \item{name}{Names - for mnemonic convenience - of Italian authors.}
  \item{x,y}{In Easting Westing}
  \item{latitude, longitude}{}
  \item{time}{POSIXct object}
  \item{day}{Day of year, counting from January 1 of the first year of observations 
  (thus day 367 is January 2 or the following year).}}}
\usage{
data(Michela)
}
\description{
GPS tracks of one roe deer (\emph{Capreolus capreolus}) in the Italian alps. 
This deer performs two seasonal migrations, from a wintering ground to a summering ground, 
back its wintering ground.  For several ways to analyze these data, see examples in the 
\link{marcher} vignette.
}
\examples{
data(Michela)
with(Michela, scan_track(time = time, x = x, y = y))

}
\references{
For more details, see: \url{Eurodeer.org}
}
\keyword{data}
