% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.r
\name{test_rangeshift}
\alias{test_rangeshift}
\alias{test_return}
\alias{test_stopover}
\alias{test_return}
\alias{test_stopover}
\title{Range shift hypothesis tests}
\usage{
test_rangeshift(FIT, verbose = TRUE)

test_return(FIT, verbose = TRUE)

test_stopover(FIT, verbose = TRUE)
}
\arguments{
\item{FIT}{a fitted range shift (output of \code{\link{estimate_shift}})}

\item{verbose}{whether to print verbose message}
}
\value{
Outputs a summary of the test results and returns a list of test results including: 
\itemize{
\item{\code{aic.table}} {an AIC table comparing models}
\item{\code{lrt}} {a likelihood ratio test statistic}
\item{\code{df}} {degrees of freedom for the l.r.t.}
\item{\code{p.value}} {a p.value for the l.r.t.}
}
}
\description{
Three tests for three hypotheses to test on fitted range shifts: Was the range shift significant?  Did an animal that performed two consecutive seasonal migrations return to the same location it began?  Was there a stopover during a migration?
}
\section{Functions}{
\itemize{
\item \code{test_rangeshift}: Compare a two range fitted model to a null model of no range shift.

\item \code{test_return}: Compares a three range fitted model in which the first and third ranges have the same centroid against a model where the first and third centroid are different.

\item \code{test_stopover}: Compare a three range model with an apparent stopover (shorter intermediate range), and see if a more parsimonious model excludes the stopover.
}}

