/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.pack;

import choco.cp.solver.constraints.global.pack.IPackSConstraint;
import choco.cp.solver.constraints.global.pack.PackSConstraint;
import choco.kernel.common.opres.nosum.INoSumCell;
import choco.kernel.common.opres.nosum.NoSumList;
import choco.kernel.common.util.bitmask.BitMask;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.awt.Point;
import java.util.ListIterator;

public final class PackFiltering {
    public final IPackSConstraint cstr;
    protected final BitMask flags;
    protected final int[] sizes;
    protected final IntDomainVar[] loads;
    private NoSumList reuseStatus;
    private boolean noFixPoint;
    protected final SumDataStruct loadSum;

    public PackFiltering(IPackSConstraint cstr, BitMask flags) {
        this.cstr = cstr;
        this.sizes = cstr.getSizes();
        this.loads = cstr.getLoads();
        this.loadSum = new SumDataStruct(this.loads, this.computeTotalSize());
        this.flags = flags;
    }

    private long computeTotalSize() {
        long l = 0L;
        int last = Integer.MAX_VALUE;
        for (int i = 0; i < this.sizes.length; ++i) {
            if (this.sizes[i] > last) {
                throw new SolverException("size must be sorted according to non increasing order");
            }
            l += (long)this.sizes[i];
            last = this.sizes[i];
        }
        return l;
    }

    protected final void updateInfLoad(int bin, int load) throws ContradictionException {
        this.noFixPoint |= this.cstr.updateInfLoad(bin, load);
    }

    protected final void updateSupLoad(int bin, int load) throws ContradictionException {
        this.noFixPoint |= this.cstr.updateSupLoad(bin, load);
    }

    protected final void pack(int item, int bin) throws ContradictionException {
        this.noFixPoint |= this.cstr.pack(item, bin);
    }

    protected final void remove(int item, int bin) throws ContradictionException {
        this.noFixPoint |= this.cstr.remove(item, bin);
    }

    protected final void loadAndSizeCoherence(int bin) throws ContradictionException {
        Point p = this.loadSum.getBounds(bin);
        this.updateInfLoad(bin, p.x);
        this.updateSupLoad(bin, p.y);
    }

    protected final void cardAndItemsCoherence(int bin) throws ContradictionException {
    }

    protected final void loadMaintenance(int bin) throws ContradictionException {
        this.updateInfLoad(bin, this.reuseStatus.getRequiredLoad());
        this.updateSupLoad(bin, this.reuseStatus.getMaximumLoad());
    }

    protected final void cardMaintenance(int bin) throws ContradictionException {
    }

    protected final void singleItemEliminationAndCommitment(int bin) throws ContradictionException {
        ListIterator<INoSumCell> iter = this.reuseStatus.listIterator();
        while (iter.hasNext()) {
            int item = iter.next().getID();
            if (this.sizes[item] + this.reuseStatus.getRequiredLoad() > this.loads[bin].getSup()) {
                this.reuseStatus.remove(iter, item);
                this.remove(item, bin);
                continue;
            }
            if (this.reuseStatus.getMaximumLoad() - this.sizes[item] >= this.loads[bin].getInf()) continue;
            this.reuseStatus.pack(iter, item);
            this.pack(item, bin);
        }
    }

    protected final void singleItemEliminationAndCommitmentAndFill(int bin) throws ContradictionException {
        ListIterator<INoSumCell> iter = this.reuseStatus.listIterator();
        while (iter.hasNext()) {
            int item = iter.next().getID();
            if (this.sizes[item] + this.reuseStatus.getRequiredLoad() > this.loads[bin].getSup()) {
                this.reuseStatus.remove(iter, item);
                this.remove(item, bin);
                continue;
            }
            if (this.reuseStatus.getMaximumLoad() - this.sizes[item] >= this.loads[bin].getInf() && this.reuseStatus.getRequiredLoad() + this.sizes[item] != this.loads[bin].getSup()) continue;
            this.reuseStatus.pack(iter, item);
            this.pack(item, bin);
        }
    }

    protected final void noSumPruningRule(NoSumList nosum, int bin) throws ContradictionException {
        if (nosum.noSum(this.loads[bin].getInf() - this.reuseStatus.getRequiredLoad(), this.loads[bin].getSup() - this.reuseStatus.getRequiredLoad())) {
            this.cstr.fail();
        }
    }

    protected final void noSumBinLoads(NoSumList nosum, int bin) throws ContradictionException {
        int value = this.loads[bin].getInf() - this.reuseStatus.getRequiredLoad();
        if (nosum.noSum(value, value)) {
            this.updateInfLoad(bin, this.reuseStatus.getRequiredLoad() + value);
        }
        if (nosum.noSum(value = this.loads[bin].getSup() - this.reuseStatus.getRequiredLoad(), value)) {
            this.updateSupLoad(bin, this.reuseStatus.getRequiredLoad() + value);
        }
    }

    protected final void noSumItemEliminationAndCommitment(NoSumList nosum, int bin) throws ContradictionException {
        ListIterator<INoSumCell> iter = this.reuseStatus.listIterator();
        while (this.reuseStatus.getNbCandidates() > 1 && iter.hasNext()) {
            int item = iter.next().getID();
            this.reuseStatus.remove(iter, item);
            if (nosum.noSum(this.loads[bin].getInf() - this.reuseStatus.getRequiredLoad() - this.sizes[item], this.loads[bin].getSup() - this.reuseStatus.getRequiredLoad() - this.sizes[item])) {
                this.remove(item, bin);
                continue;
            }
            if (nosum.noSum(this.loads[bin].getInf() - this.reuseStatus.getRequiredLoad(), this.loads[bin].getSup() - this.reuseStatus.getRequiredLoad())) {
                this.reuseStatus.packRemoved(item);
                this.pack(item, bin);
                continue;
            }
            this.reuseStatus.undoRemove(iter, item);
        }
    }

    public void propagate() throws ContradictionException {
        IStateIntVector abins = this.cstr.getAvailableBins();
        int n = abins.size();
        this.noFixPoint = true;
        while (this.noFixPoint) {
            this.noFixPoint = false;
            this.loadSum.update();
            for (int i = 0; i < n; ++i) {
                this.propagate(abins.quickGet(i));
            }
        }
        this.cstr.fireAvailableBins();
    }

    private void propagate(int bin) throws ContradictionException {
        this.loadAndSizeCoherence(bin);
        this.reuseStatus = this.cstr.getStatus(bin);
        this.loadMaintenance(bin);
        if (this.flags.contains(PackSConstraint.FILL_BIN)) {
            this.singleItemEliminationAndCommitmentAndFill(bin);
        } else {
            this.singleItemEliminationAndCommitment(bin);
        }
        if (this.flags.contains(PackSConstraint.ADDITIONAL_RULES) && this.reuseStatus.getNbCandidates() > 1) {
            this.noSumPruningRule(this.reuseStatus, bin);
            this.noSumBinLoads(this.reuseStatus, bin);
            this.noSumItemEliminationAndCommitment(this.reuseStatus, bin);
        }
    }

    static final class SumDataStruct {
        protected final IntDomainVar[] vars;
        public final long sum;
        protected long sumMinusInfs;
        protected long sumMinusSups;

        public SumDataStruct(IntDomainVar[] vars, long sum) {
            this.vars = vars;
            this.sum = sum;
        }

        public void update() {
            this.sumMinusInfs = this.sum;
            this.sumMinusSups = this.sum;
            for (int i = 0; i < this.vars.length; ++i) {
                this.sumMinusInfs -= (long)this.vars[i].getInf();
                this.sumMinusSups -= (long)this.vars[i].getSup();
            }
        }

        public Point getBounds(int idx) {
            return new Point((int)(this.sumMinusSups + (long)this.vars[idx].getSup()), (int)(this.sumMinusInfs + (long)this.vars[idx].getInf()));
        }
    }
}

