% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass.R
\name{mass}
\alias{mass}
\alias{mass_pre}
\title{Computes the Distance between the 'data' and the 'query'.}
\usage{
mass(
  pre_obj,
  data,
  query = data,
  index = 1,
  version = c("v3", "v2"),
  n_workers = 1
)

mass_pre(
  data,
  window_size,
  query = NULL,
  type = c("normalized", "non_normalized", "absolute", "weighted"),
  weights = NULL
)
}
\arguments{
\item{pre_obj}{Required. This is the object resulting from \code{mass_pre()}. The is no \emph{MASS} without a \emph{pre}.}

\item{data}{Required. Any 1-dimension series of numbers (\code{matrix}, \code{vector}, \code{ts} etc.)}

\item{query}{Optional. Accepts the same types as \code{data} and is used for join-similarity. Defaults to \code{data} for
self-similarity. \strong{IMPORTANT} Use the same data used on \code{mass_pre()}.}

\item{index}{An \code{integer}. This is the index of the rolling window that will be used. Must be between \code{1} and
\code{length(data) - window_size + 1}.}

\item{version}{A \code{string}. Chooses the version of MASS what will be used. Ignored if \code{mass_pre()} is not the
"normalized" type.}

\item{n_workers}{An \code{integer} The number of threads using for computing. Defaults to \code{1}.}

\item{window_size}{Required. An integer defining the rolling window size.}

\item{type}{This changes how the MASS algorithm will compare the rolling window and the data. (See details).}

\item{weights}{Optional. It is used when the \code{type} is \code{weighted}, and has to be the same size as the \code{window_size}.}
}
\value{
\code{mass()} returns a \code{list} with the \code{distance_profile} and the \code{last_product} that is only useful for computing the
Matrix Profile.

\code{mass_pre()} returns a \code{list} with several precomputations to be used on MASS later. \strong{Attention} use this before
\code{mass()}.
}
\description{
This algorithm will use a rolling window, to computes the distance thorough the whole data. This means that the
minimum distance found is the \emph{motif} and the maximum distance is the \emph{discord} on that time series. \strong{Attention}
you need first to create an object using \code{mass_pre()}. Read below.
}
\details{
There are currently four ways to compare the window with the data:
\enumerate{
\item \strong{normalized}: this normalizes the data and the query window. This is the most frequently used.
\item \strong{non_normalized}: this won't normalize the query window. The data still being normalized.
\item \strong{absolute}: this won't normalize both the data and the query window.
\item \strong{weighted}: this normalizes the data and query window, and also apply a weight vector on the query.
}
}
\examples{
pre <- mass_pre(motifs_discords_small, 50)
dist_profile <- mass(pre, motifs_discords_small)
pre <- mass_pre(motifs_discords_small, 50)
dist_profile <- mass(pre, motifs_discords_small)
}
