% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncate.R
\name{truncate}
\alias{truncate}
\title{Truncate a Data Frame or Matrix}
\usage{
truncate(.data, keep_rows = FALSE)
}
\arguments{
\item{.data}{A data frame or matrix to be truncated}

\item{keep_rows}{Logical. If TRUE, replaces non-NA values with NA instead of removing all data}
}
\value{
An empty data frame or matrix with the same structure as the input
}
\description{
Remove all rows from a literature matrix but preserve the general structure. Mimics SQL's TRUNCATE operation by clearing data while preserving structure.
}
\examples{
# Completely empty a data frame
df <- data.frame(x = 1:3, y = 4:6)
truncate(df)

# Replace non-NA values with NA while keeping structure
truncate(df, keep_rows = TRUE)

}
