% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch.R
\name{add_batch_record}
\alias{add_batch_record}
\title{Add Multiple Records to a literature matrix}
\usage{
add_batch_record(.data, ..., .before = NULL, .after = NULL)
}
\arguments{
\item{.data}{A data frame to which records will be added}

\item{...}{One or more records to add. Each record can be either:
\itemize{
  \item A list with the same length as the number of columns in `.data`
  \item A data frame with the same column structure as `.data`
}}

\item{.before}{Row number before which to insert the new records.
If NULL (default), and `.after` is also NULL, records are appended to the end.}

\item{.after}{Row number after which to insert the new records.
If NULL (default), and `.before` is also NULL, records are appended to the end.}
}
\value{
A data frame with the new records added at the specified position
}
\description{
Adds one or more records to a literature matrix at a specified position. Records can be
provided as lists or data frames, and can be inserted before or after specific rows.
}
\examples{

# Create sample data frame
df <- data.frame(
  name = c("John", "Jane"),
  age = c(25, 30)
)

# Add a single record as a list
df <- add_batch_record(df, list(name = "Bob", age = 35))

# Add multiple records as data frames
new_records <- data.frame(
  name = c("Alice", "Charlie"),
  age = c(28, 40)
)
df <- add_batch_record(df, new_records, .before = 2)

}
