% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbX_functions.R
\name{ezstat}
\alias{ezstat}
\title{Statistical Analysis and Visualization of Microbiome Data}
\usage{
ezstat(microbiome_data, metadata, level, selected_metadata)
}
\arguments{
\item{microbiome_data}{Character; path to the microbiome abundance table (CSV, TSV, XLS, or XLSX).}

\item{metadata}{Character; path to the sample metadata file (CSV, TXT, XLS, or XLSX).}

\item{level}{Character; taxonomic rank to aggregate at (e.g. "genus", "g").}

\item{selected_metadata}{Character; name of the categorical metadata column to group by.}
}
\value{
Invisibly returns the \code{data.frame} of cleaned sample_taxa abundances used for all analyses.
}
\description{
Performs Kruskal_Wallis tests, post_hoc Dunn comparisons, Compact Letter Display (CLD)
summaries, and generates boxplots annotated with CLD letters for taxa abundances
grouped by a chosen metadata variable.
}
\details{
This function first calls ezclean to produce a cleaned, merged table of sample IDs,
metadata, and taxa abundances at the requested taxonomic level.  It then:
\enumerate{
  \item Runs Kruskal_Wallis tests on each taxon and writes results with FDR_correction.
  \item Performs Dunns pairwise post_hoc tests (BH_adjusted) for taxa with KW p less than or equal to 0.05.
  \item Computes CLD letters for significantly different groups and writes a summary Excel.
  \item Generates high-resolution (900 dpi) boxplots annotated with CLD letters.
}
}
\examples{
\dontrun{
  mb  <- system.file("extdata", "microbiome.csv", package = "mbX")
  md  <- system.file("extdata", "metadata.csv",   package = "mbX")
  if (nzchar(mb) && nzchar(md)) {
    ezstat(mb, md, "genus", "Group")
  }
}

}
