% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{dissolve_sf_by_attribute}
\alias{dissolve_sf_by_attribute}
\title{Dissolve sf object by attribute}
\usage{
dissolve_sf_by_attribute(x, by = character(0))
}
\arguments{
\item{x}{(\link[sf:sf]{sf::sf} object) SF object to dissolve}

\item{by}{(\code{character(N)}, default character(0)) Attributes to dissolve by}
}
\value{
Dissolved \link[sf:sf]{sf::sf} object
}
\description{
Dissolve an SF object by attribute
}
\details{
Inspired by \link[spatialEco:sf_dissolve]{spatialEco::sf_dissolve}
}
\examples{
\dontrun{
  communes_sf <- sf::st_read(system.file("extdata/Benin_communes.gpkg", package = "mbg"))
  departments_sf <- mbg::dissolve_sf_by_attribute(
    x = communes_sf,
    by = c('department', 'department_code')
  )
}

}
