% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_classes.R
\name{print.summary.mcc}
\alias{print.summary.mcc}
\title{Print method for \code{mcc} summary objects}
\usage{
\method{print}{summary.mcc}(x, ...)
}
\arguments{
\item{x}{A \code{summary.mcc} object}

\item{...}{Additional arguments (currently unused)}
}
\value{
Invisibly returns \code{x}
}
\description{
Print method for \code{mcc} summary objects
}
\examples{
# Attach dplyr
library(dplyr)
# Create sample data with recurrent events
df <- data.frame(
  id = c(1, 2, 3, 4, 4, 4, 4, 5, 5),
  time = c(8, 1, 5, 2, 6, 7, 8, 3, 3),
  cause = c(0, 0, 2, 1, 1, 1, 0, 1, 2)
 ) |>
  arrange(id, time)  # Sort the data by id and time

# Calculate MCC using the equation method (default)
mcc_eq <- mcc(df, id_var = "id", time_var = "time", cause_var = "cause")

summary(mcc_eq)

# Calculate MCC using the sum of cumulative incidence method
mcc_sci <- mcc(
  df,
  id_var = "id",
  time_var = "time",
  cause_var = "cause",
  method = "sci"
)

print(summary(mcc_sci))

# Clean up
rm(df, mcc_eq, mcc_sci)

}
