% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/re.R
\name{re}
\alias{re}
\alias{as_re}
\alias{as.re}
\title{Build a regular expression}
\usage{
re(x, perl = TRUE, ...)

as_re(x, perl = TRUE, ...)

as.re(x, perl = TRUE, ...)
}
\arguments{
\item{x}{Character vector of length one. The value of this character vector
is assumed to be a well-formed regular expression. In the current implementation
this is assumed, not checked.}

\item{perl}{Logical. If \code{TRUE}, \code{x} is assumed to use PCRE (i.e. Perl
Compatible Regular Expressions) notation. If \code{FALSE}, \code{x} is assumed to use
base R's default regular expression notation.
Contrary to base R's regular expression functions, \code{\link[=re]{re()}} assumes that the
PCRE regular expression flavor is used by default.}

\item{...}{Additional arguments.}
}
\value{
An object of class \code{re}, which is a wrapper around a character vector
flagging it as containing a regular expression. In essence it is a named
list: the \code{x} item contains the \code{x} input and the \code{perl} item contains
the value of the \code{perl} argument (\code{TRUE} by default).

It has basic methods such as \code{\link[=print]{print()}}, \code{\link[=summary]{summary()}} and \code{\link[=as.character]{as.character()}}.
}
\description{
Create an object of class \code{re} or coerce a character vector to an object of
class \code{re}.
}
\details{
This class exists because some functions in the mclm package
require their arguments to be marked as being regular expressions.
For example, \code{\link[=keep_re]{keep_re()}} does not need its \code{pattern} argument to be a \code{\link{re}}
object, but if the user wants to subset items with \link{brackets} using
a regular expression, they must use a \code{\link{re}} object.
}
\examples{
toy_corpus <- "Once upon a time there was a tiny toy corpus.
  It consisted of three sentences. And it lived happily ever after."

(tks <- tokenize(toy_corpus))

# In `keep_re()`, the use of `re()` is optional
keep_re(tks, re("^.{3,}"))
keep_re(tks, "^.{3,}")

# When using brackets notation, `re()` is necessary
tks[re("^.{3,}")]
tks["^.{3,}"]

# build and print a `re` object
re("^.{3,}")
as_re("^.{3,}")
as.re("^.{3,}")
print(re("^.{3,}"))
}
\seealso{
\code{\link[=perl_flavor]{perl_flavor()}}, \code{\link[=scan_re]{scan_re()}}, \code{\link[=cat_re]{cat_re()}}
}
