% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_na.R
\name{fill_na.mcarray}
\alias{fill_na.mcarray}
\title{Fill Missing Values}
\usage{
\method{fill_na}{mcarray}(x, value = 0, ...)
}
\arguments{
\item{x}{An object.}

\item{value}{A scalar of the value to replace values with.}

\item{...}{Other arguments passed to methods.}
}
\value{
The modified object.
}
\description{
Fills all of an object's missing values
while preserving the object's dimensionality and class.
}
\details{
It should only be defined for objects with values of consistent class ie
not standard data.frames.
}
\section{Methods (by class)}{

\itemize{
\item \code{fill_na(logical)}: Fill Missing Values for logical Objects

\item \code{fill_na(integer)}: Fill Missing Values for integer Objects

\item \code{fill_na(numeric)}: Fill Missing Values for numeric Objects

\item \code{fill_na(character)}: Fill Missing Values for character Objects

}
}

\examples{
# logical
fill_na(c(TRUE, NA))

# integer
fill_na(c(1L, NA), 0)

# numeric
fill_na(c(1, NA), Inf)

# character
fill_na(c("text", NA))
fill_na(matrix(c("text", NA)), value = Inf)
}
\seealso{
Other fill: 
\code{\link[extras]{fill_all}()}
}
