% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-class-dcm-estimate.R
\name{dcm_estimate}
\alias{dcm_estimate}
\title{Fit Bayesian diagnostic classification models}
\usage{
dcm_estimate(
  dcm_spec,
  data,
  missing = NA,
  identifier = NULL,
  method = c("variational", "mcmc", "optim", "pathfinder"),
  backend = getOption("measr.backend", "rstan"),
  file = NULL,
  file_refit = getOption("measr.file_refit", "never"),
  ...
)
}
\arguments{
\item{dcm_spec}{A DCM specification created with \code{\link[=dcm_specify]{dcm_specify()}}.}

\item{data}{Response data. A data frame with 1 row per respondent and 1
column per item.}

\item{missing}{An \code{R} expression specifying how missing data in \code{data} is
coded (e.g., \code{NA}, \code{"."}, \code{-99}, etc.). The default is \code{NA}.}

\item{identifier}{Optional. Variable name of a column in \code{data} that
contains respondent identifiers. \code{NULL} (the default) indicates that no
identifiers are present in the data, and row numbers will be used as
identifiers.}

\item{method}{Estimation method. Options are \code{"variational"}, which uses
Stan's variational algorithm; \code{"mcmc"}, which uses Stan's sampling method;
\code{"optim"}, which uses Stan's optimizer; or \code{"pathfinder"} which uses Stan's
pathfinder variational inference algorithm (only available if
\code{backend = "cmdstanr"}).}

\item{backend}{Character string naming the package to use as the backend for
fitting the Stan model. Options are \code{"rstan"} (the default) or
\code{"cmdstanr"}. Can be set globally for the current \code{R} session via the
"measr.backend" option (see \code{\link[=options]{options()}}). Details on the rstan and
cmdstanr packages are available at \url{https://mc-stan.org/rstan/} and
\url{https://mc-stan.org/cmdstanr/}, respectively.}

\item{file}{Either \code{NULL} (the default) or a character string. If a character
string, the fitted model object is saved as an \code{.rds} object using
\code{\link[=saveRDS]{saveRDS()}} using the supplied character string. The \code{.rds} extension
is automatically added. If the specified file already exists, measr
will load the previously saved model. Unless \code{file_refit} is specified, the
model will not be refit.}

\item{file_refit}{Controls when a saved model is refit. Options are
\code{"never"}, \code{"always"}, and \code{"on_change"}. Can be set globally for the
current \code{R} session via the "measr.file_refit" option (see \code{\link[=options]{options()}}).
\itemize{
\item For \code{"never"} (the default), the fitted model is always loaded if the
\code{file} exists, and model fitting is skipped.
\item For \code{"always"}, the model is always refitted, regardless of whether or
not \code{file} exists.
\item For \code{"on_change"}, the model will be refit if the \code{dcm_spec}, \code{data},
\code{method}, or \code{backend} specified are different from that in the saved
\code{file}.
}}

\item{...}{Additional arguments passed to Stan.
\itemize{
\item For \code{backend = "rstan"}, arguments are passed to \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}}
or \code{\link[rstan:stanmodel-method-optimizing]{rstan::optimizing()}}.
\item For \code{backend = "cmdstanr"}, arguments are passed to the
\code{\link[cmdstanr:model-method-sample]{$sample()}} or
\code{\link[cmdstanr:model-method-optimize]{$optimize()}} methods of the
\link[cmdstanr:CmdStanModel]{CmdStanModel} class.
}}
}
\value{
A \code{measrdcm} object.
}
\description{
Estimate diagnostic classification models (\acronym{DCM}s; also known as
cognitive diagnostic models) using 'Stan'. Models can be estimated using
Stan's optimizer, or full Markov chain Monte Carlo (\acronym{MCMC}).
}
\examples{
\dontshow{if (measr_examples()) withAutoprint(\{ # examplesIf}
model_spec <- dcm_specify(
  qmatrix = dcmdata::mdm_qmatrix,
  identifier = "item"
)
model <- dcm_estimate(
  dcm_spec = model_spec,
  data = dcmdata::mdm_data,
  identifier = "respondent",
  method = "optim",
  seed = 63277
)
\dontshow{\}) # examplesIf}
}
\concept{Bayesian}
\concept{Cmd}
\concept{DCM}
\concept{Model}
\concept{Stan}
