
#' Lagged data generated by \code{\link{prepareLaggedData}}.
#'
#' A dataframe resulting from the application of \code{\link{prepareLaggedData}} to the dataset \code{\link{palaeodata}}. The dataframe columns are:
#'
#' \itemize{
#'   \item \emph{Response_0} numeric, values of the response variable selected by the user in the argument \code{response} of the function \code{\link{prepareLaggedData}}. This column is used as response variable by the function \code{\link{computeMemory}}. In this case, Response represent pollen counts of Pinus.
#'   \item \emph{Response_0.2-1} numeric, time delayed values of the response for different lags (in ky). Considered together these columns represent the endogenous ecological memory.
#'   \item \emph{climate.temperatureAverage_0} numeric, values of the variable temperatureAverage for the lag 0 (no lag). This column represents the concurrent effect of the temperature over the response.
#'   #'   \item \emph{climate.rainfallAverage_0} numeric, values of the variable rainfallAverage for the lag 0 (no lag). This column represents the concurrent effect of rainfall over the response.
#'   \item \emph{climate.temperatureAverage_0.2-1} numeric, time delayed values of temperatureAverage for lags 0.2 to 1 (in ky).
#'   #'   \item \emph{climate.rainfallAverage_0.2-1} numeric, time delayed values of rainfallAverage for lags 0.2 to 1 (in ky).
#' }
#'
#' @author Blas M. Benito  <blasbenito@gmail.com>
#' @docType data
#' @keywords datasets
#' @name palaeodataLagged
#' @usage data(palaeodataLagged)
#' @format dataframe with 13 columns and 3988 rows.
"palaeodataLagged"


#' Dataframe with pollen counts.
#'
#' A dataframe with the following columns:
#'
#' \itemize{
#'   \item \emph{age} in kiloyears before present (ky BP).
#'   \item \emph{pinus} pollen counts of Pinus.
#'   \item \emph{quercus} pollen counts of Quercus.
#'   \item \emph{poaceae} pollen counts of Poaceae.
#'   \item \emph{artemisia} pollen counts of Artemisia.
#' }
#' @author Blas M. Benito  <blasbenito@gmail.com>
#' @docType data
#' @keywords datasets
#' @name pollen
#' @usage data(pollen)
#' @format dataframe with 5 columns and 639 rows.
"pollen"


#' Dataframe with palaeoclimatic data.
#'
#' A dataframe containing palaeoclimate data at 1 ky temporal resolution with the following columns:
#'
#' \itemize{
#'   \item \emph{age} in kiloyears before present (ky BP).
#'   \item \emph{temperatureAverage} average annual temperature in Celsius degrees.
#'   \item \emph{rainfallAverage} average annual precipitation in milimetres per day (mm/day).
#'   \item \emph{temperatureWarmestMonth} average temperature of the warmest month, in Celsius degrees.
#'   \item \emph{temperatureColdestMonth} average temperature of the coldest month, in Celsius degrees.
#'   \item \emph{oxigenIsotope} delta O18, global ratio of stable isotopes in the sea floor, see \url{http://lorraine-lisiecki.com/stack.html} for further details.
#' }
#' @author Blas M. Benito  <blasbenito@gmail.com>
#' @docType data
#' @keywords datasets
#' @name climate
#' @usage data(climate)
#' @format dataframe with 6 columns and 800 rows.
"climate"


#' Dataframe with pollen and climate data.
#'
#' A dataframe with a regular time grid of 0.2 ky resolution resulting from applying \code{\link{mergePalaeoData}} to the datasets \code{\link{climate}} and \code{\link{pollen}}:
#'
#' \itemize{
#'   \item \emph{age} in ky before present (ky BP).
#'   \item \emph{pinus} pollen counts of Pinus.
#'   \item \emph{quercus} pollen counts of Quercus.
#'   \item \emph{poaceae} pollen counts of Poaceae.
#'   \item \emph{artemisia} pollen counts of Artemisia.
#'   \item \emph{temperatureAverage} average annual temperature in Celsius degrees.
#'   \item \emph{rainfallAverage} average annual precipitation in milimetres per day (mm/day).
#'   \item \emph{temperatureWarmestMonth} average temperature of the warmest month, in Celsius degrees.
#'   \item \emph{temperatureColdestMonth} average temperature of the coldest month, in Celsius degrees.
#'   \item \emph{oxigenIsotope} delta O18, global ratio of stable isotopes in the sea floor, see \url{http://lorraine-lisiecki.com/stack.html} for further details.
#' }
#' @author Blas M. Benito  <blasbenito@gmail.com>
#' @docType data
#' @keywords datasets
#' @name palaeodata
#' @usage data(palaeodata)
#' @format dataframe with 10 columns and 7986 rows.
"palaeodata"


#' Output of \code{\link{computeMemory}}
#'
#' List containing the output of \code{\link{computeMemory}} applied to \code{\link{palaeodataLagged}}. Its slots are:
#'
#'  \itemize{
#'  \item \code{memory} dataframe with five columns:
#'     \itemize{
#'       \item \code{Variable} character, names and lags of the different variables used to model ecological memory.
#'       \item \code{median} numeric, median importance across \code{repetitions} of the given \code{Variable} according to Random Forest.
#'       \item \code{sd} numeric, standard deviation of the importance values of the given \code{Variable} across \code{repetitions}.
#'       \item \code{min} and \code{max} numeric, percentiles 0.05 and 0.95 of importance values of the given \code{Variable} across \code{repetitions}.
#'     }
#'  \item \code{R2} vector, values of pseudo R-squared value obtained for the Random Forest model fitted on each repetition. Pseudo R-squared is the Pearson correlation beteween the observed and predicted data.
#'  \item \code{prediction} dataframe, with the same columns as the dataframe in the slot \code{memory}, with the median and confidence intervals of the predictions of all random forest models fitted.
#'  \item \code{multicollinearity} multicollinearity analysis on the input data performed with \link[HH]{vif}. A vif value higher than 5 indicates that the given variable is highly correlated with other variables.
#' }
#' @author Blas M. Benito  <blasbenito@gmail.com>
#' @docType data
#' @keywords datasets
#' @name palaeodataMemory
#' @usage data(palaeodataMemory)
#' @format List with four slots.
"palaeodataMemory"

#' @import ggplot2 viridis viridisLite zoo stringr ranger HH tidyr
NULL

#' @import utils
utils::globalVariables(c("prediction", "Lag", "median", "Variable", "sd", "parameters"))
