% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCodeInResponse.R
\name{runCodeInResponse}
\alias{runCodeInResponse}
\title{Executes the code in the received response from the agent}
\usage{
runCodeInResponse(
  response,
  prompt = NULL,
  agent = NULL,
  context = NULL,
  correction = c("none", "selfcorrect", "sampleMore", "sampleThenCorrect",
    "correctThenSample"),
  attempts = 3,
  output.file = NULL,
  ...
)
}
\arguments{
\item{response}{response to be parsed for code and executed}

\item{prompt}{prompt for the response, if correction="none" it is not needed}

\item{agent}{AI agent, if correction="none" it is not needed}

\item{context}{context for the prompt, if correction="none" it is not needed}

\item{correction}{"none" no code correction is needed. "selfcorrect" feedback the errors to LLM and ask for fix.
"sampleMore" sample responses for the #prompt until an executable code is returned or number of attempts reached.
"correctThenSample" first try self-correct "attempt" number of times.
If no executable code is returned. It will sample new responses "attempt" number of times or until executable code}

\item{attempts}{Numeric value denoting how many times the code should be sent back for fixing.}

\item{output.file}{Optional output file created holding parsed code}

\item{...}{arguments to sendPrompt()}
}
\value{
A list containing the following elements:
\item{init.response}{A character vector representing the initial prompt response.}
\item{init.blocks}{A list of initial blocks.}
\item{final.blocks}{A list of final blocks.}
\item{code.works}{A boolean value indicating whether the code works.}
\item{exec.result}{A character string representing the execution results.}
\item{tried.attempts}{An integer representing the number of attempts.}
}
\description{
The function extracts and executes the code in the response. If required it can
try to correct errors in the code via different strategies.
}
\examples{
\dontrun{

resp.list <- runCodeInResponse(agent,prompt,context=rbionfoExp,correction="sampleMore",attempt=2)
}
}
\seealso{
\code{\link{selfcorrect}},\code{\link{sampleResponse}}
}
