% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_independent_matrix.R
\name{get_independent_matrix}
\alias{get_independent_matrix}
\title{Generate independent HEMs}
\usage{
get_independent_matrix(cor_matrix = NULL, dep_lvl = NULL)
}
\arguments{
\item{cor_matrix}{Correlation matrix}

\item{dep_lvl}{Dependency level allowed. A number between 0 and 1 indicating the maximum correlation allowed between HEMs.}
}
\value{
Returns a list of independent HEMs
}
\description{
There may be some HEMs which are linear dependent on another HEM.
This produces conflicts when generating the multivariate Gaussian distribution as the Sigma matrix will not be invertible, causing an error.
To avoid this, \code{get_independent_matrix} tells the user which HEMs are independent so they can choose which HEMs to use.
To do so the user must input the maximum correlation between HEMs by \code{dep_lvl}.
If \code{dep_lvl} is too high (>0.95) the user may leave very dependent HEMs and thus the Sigma matrix will not be invertible.
We advise the user to lower the \code{dep_lvl} until the Sigma matrix is invertible.
}
\examples{
n_pmcs <- 6
data_much <- mergingTools::process_raw_experiments(data = data_much_raw_vignette,
                                                  n_pmcs = n_pmcs)
cor_matrix <- mergingTools::correlation_matrix(splitted_data = data_much)
dep_lvl <- 0.85
# Remove the HEMs which are linearly dependant on other HEMs
cor_matrix_independent <- mergingTools::get_independent_matrix(cor_matrix = cor_matrix,
                                                               dep_lvl = dep_lvl)
}
\keyword{MUCH}
