% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnet_summarize.R
\name{mnet_summarize}
\alias{mnet_summarize}
\title{Produce a daily summary of Oklahoma Mesonet subdaily data}
\usage{
mnet_summarize(
  sub_daily,
  tz = "Etc/GMT+6",
  interval = "1 day",
  include_qc_variables = FALSE
)
}
\arguments{
\item{sub_daily}{a data frame with subdaily measurements from the Oklahoma Mesonet
such as that produced by \code{\link[=mnet_read_mts]{mnet_read_mts()}}.}

\item{tz}{a length-one character vector specifying which time zone to use for daily summary. Use
\code{\link[base:timezones]{base::OlsonNames()}} to obtain a listing of valid available time zones.}

\item{interval}{the interval over which to summarize data. May be defined as
a difftime object (see \code{\link[base:difftime]{base::difftime()}}) or a character value compatible
with \code{\link[units:units]{units::as_units()}}. Tested intervals include "1 day" (the default),
"30 min", and "1 hour", although other intervals may work (e.g. "3 hours").}

\item{include_qc_variables}{a length-one logical vector specifying whether or
or not to include quality control variables (e.g. number of errant
observations) in the output}
}
\value{
A data frame with daily summaries of Oklahoma Mesonet data. See
\code{\link[=mnet_variable_definition]{mnet_variable_definition()}} or the table below for the ID, variable name,
unit and description for each column.\tabular{llll}{
   \strong{ID} \tab \strong{Variable Name} \tab \strong{Unit} \tab \strong{Description} \cr
   2AVG \tab Average Wind Speed at 2m \tab meters per second \tab Average of all 5-minute 2m wind speed observations each day. \cr
   2BAD \tab Number of Errant 2m Wind Speed Observations \tab number of 5-minute observations \tab Number of errant 5-minute 2m wind speed observations each day. \cr
   2DEV \tab Standard Deviation of Wind Speed at 2m \tab meters per second \tab Standard deviation of the wind speed at 2m during a 5-minute observation period. \cr
   2MAX \tab Maximum 2m Wind Speed \tab meters per second \tab Highest 5-minute averaged 2m wind speed measurement each day. \cr
   2MIN \tab Minimum 2m Wind Speed \tab meters per second \tab Lowest 5-minute averaged 2m wind speed measurement each day. \cr
   9AVG \tab Average Air Temperature at 9m \tab degrees Celsius \tab Average of all 5-minute averaged 9-m air temperature observations each day. \cr
   9BAD \tab Number of Errant 9m Air Temperature Observations \tab number of 5-minute observations \tab Number of errant 5-minute 9m air temperature observations each day. \cr
   ABAD \tab Number of Errant Solar Radiation Observations \tab number of 5-minute observations \tab Number of errant 5-minute solar radiation observations each day. \cr
   AMAX \tab Maximum Solar Radiation \tab Watts per square meter \tab Highest 5-minute averaged solar radiation measurement each day. \cr
   AMAXO \tab Maximum Solar Radiation Observation Number \tab 5-minute observation number \tab Daily observation number that measured highest 5-minute averaged solar radiation value each day \cr
   ATOT \tab Total Solar Radiation \tab mega Joules per square meter \tab Daily accumulation of solar radiation each day. \cr
   B5AV \tab Average Temperature Under Bare Soil at 5cm \tab degrees Celsius \tab Average of all 15-minute averaged soil temperature observations each day. \cr
   B5BD \tab Number of Errant Temperature Under Bare Soil at 5cm Observations \tab number of 15-minute observations \tab Number of errant 15-minute temperature under bare soil at 5cm observations each day. This variable is only available prior to December 1, 2013. \cr
   B5MN \tab Minimum Temperature Under Bare Soil at 5cm \tab degrees Celsius \tab Lowest 15-minute averaged soil temperature observation each day. This variable is only available prior to December 1, 2013. \cr
   B5MNO \tab Minimum Temperature Under Bare Soil at 5cm Observation Number \tab 15-minute observation number \tab Daily 15-minute observation number that measured minimum temperature under bare soil at 5cm each day. This variable is only available prior to December 1, 2013. \cr
   B5MX \tab Maximum Temperature Bare Soil at 5cm \tab degrees Celsius \tab Highest 15-minute averaged soil temperature observation each day. This variable is only available prior to December 1, 2013. \cr
   B5MXO \tab Maximum Temperature Under Bare Soil at 5cm Observation Number \tab 15-minute observation number \tab Daily 15-minute observation number that measured maximum temperature under bare soil at 5cm each day. This variable is only available prior to December 1, 2013. \cr
   BAVG \tab Average Temperature Under Bare Soil at 10cm \tab degrees Celsius \tab Average of all 15-minute averaged soil temperature observations each day. This variable is only available prior to December 1, 2013. \cr
   BBAD \tab Number of Errant Temperature Under Bare Soil at 10cm Observations \tab number of 15-minute observations \tab Number of errant 15-minute temperature under bare soil at 10cm observations each day. \cr
   BMAX \tab Maximum Temperature Bare Soil at 10cm \tab degrees Celsius \tab Highest 15-minute averaged soil temperature observation each day. \cr
   BMAXO \tab Maximum Temperature Under Bare Soil at 10cm Observation Number \tab 15-minute observation number \tab Daily 15-minute observation number that measured maximum temperature under bare soil at 10cm each day. \cr
   BMIN \tab Minimum Temperature Under Native Vegetation at 10cm \tab degrees Celsius \tab Lowest 15-minute averaged soil temperature observation each day. \cr
   BMINO \tab Minimum Temperature Under Bare Soil at 10cm Observation Number \tab 15-minute observation number \tab Daily 15-minute observation number that measured minimum temperature under bare soil at 10cm each day. \cr
   CDEG \tab Cooling Degree Days \tab degrees Celsius \tab Number of degrees Celsius    that the average daily air temperature is greater than 65 degrees Celsius   . \cr
   DATE \tab Date of summary in Central Standard Time \tab  \tab  \cr
   DAVG \tab Average Dewpoint Temperature \tab degrees Celsius \tab Average of all 5-minute averaged dewpoint temperatures each day. Dewpoint temperature is derived from 1.5m air temperature and the corresponding humidity value. \cr
   DBAD \tab Number of Errant Dewpoint Temperature Observations \tab number of 5-minute observations \tab Number of errant 5-minute dewpoint temperature observations each day. \cr
   DMAX \tab Maximum Dewpoint Temperature \tab degrees Celsius \tab Highest 5-minute averaged dewpoint temperature each day. Dewpoint temperature is derived from 1.5m air temperature and the corresponding humidity value. \cr
   DMAXO \tab Maximum Daily Dewpoint Temperature Observation Number \tab 5-minute observation number \tab Daily observation number that measured highest 5-minute averaged dewpoint temperature each day. \cr
   DMIN \tab Minimum Dewpoint Temperature \tab degrees Celsius \tab Lowest 5-minute averaged dewpoint temperature each day. Dewpoint temperature is derived from 1.5m air temperature and the corresponding humidity value. \cr
   DMINO \tab Minimum Daily Dewpoint Temperature Observation Number \tab 5-minute observation number \tab Daily observation number that measured lowest 5-minute averaged dewpoint temperature each day. \cr
   HAVG \tab Average Humidity \tab percent \tab Average of all 5-minute averaged humidity observations each day. \cr
   HBAD \tab Number of Errant Humidity Observations \tab number of 5-minute observations \tab Number of errant 5-minute humidity observations each day. \cr
   HDEG \tab Heating Degree Days \tab degrees Celsius \tab Number of degrees Celsius that the average daily air temperature is less than 18.3 degrees Celsius. \cr
   HMAX \tab Maximum Humidity \tab percent \tab Highest 5-minute averaged humidity observation reported each day. \cr
   HMAXO \tab Maximum Daily Humidity Observation Number \tab 5-minute observation number \tab Daily observation number that measured highest 5-minute averaged humidity each day. \cr
   HMIN \tab Minimum Humidity \tab percent \tab Lowest 5-minute averaged humidity observation reported each day. \cr
   HMINO \tab Minimum Daily Humidity Observation Number \tab 5-minute observation number \tab Daily observation number that measured lowest 5-minute averaged humidity each day. \cr
   HTBAD \tab Number of Errant Heat Index Observations \tab number of 5-minute observations \tab Number of errant 5-minute heat index observations each day. \cr
   HTMX \tab Maximum Heat Index Temperature \tab degrees Celsius \tab Largest 5-minute averaged heat index observation each day. Derived using 5-minute averaged air temperature and corresponding 5-minute averaged humidity observation. \cr
   HTMXO \tab Maximum Daily Heat Index Observation Number \tab 5-minute observation number \tab Daily observation number that measured highest 5-minute averaged heat index each day. \cr
   IBAD \tab Number of Errant Wind Direction Observations \tab number of 5-minute observations \tab Number of errant 5-minute 10m wind direction observations each day. \cr
   MSLP \tab Mean Sea Level Pressure \tab inches of mercury \tab Average of all 5-minute averaged station air pressure observations adjusted for station elevation each day. \cr
   PAVG \tab Average Station Pressure \tab inches of mercury \tab Average of all 5-minute averaged station air pressure observations each day. \cr
   PBAD \tab Number of Errant Station Pressure Observations \tab number of 5-minute observations \tab Number of errant 5-minute station pressure observations each day. \cr
   PDFQ \tab Primary Wind Direction Frequency \tab percentage \tab Frequency of observations in the given wind direction category. \cr
   PDIR \tab Primary Wind Direction \tab 16-point cardinal direction \tab Most common wind direction for the day based on 16-point compass heading (i.e., 0 is N; 1 is NNE; 15 is NNW). \cr
   PMAX \tab Maximum Station Pressure \tab inches of mercury \tab Highest 5-minute averaged station air pressure observation each day. \cr
   PMAXO \tab Maximum Daily Station Pressure Observation Number \tab 5-minute observation number \tab Daily observation number that measured highest 5-minute averaged station pressure each day. \cr
   PMIN \tab Minimum Station Pressure \tab inches of mercury \tab Lowest 5-minute averaged station air pressure observation each day. \cr
   PMINO \tab Minimum Daily Station Pressure Observation Number \tab 5-minute observation number \tab Daily observation number that measured lowest 5-minute averaged station pressure each day. \cr
   R05BD \tab Number of Errant Soil Moisture Calibrated Delta-T at 5cm Observations \tab number of 30-minute observations \tab Number of errant 30-minute calibrated delta-t at 5cm observations. \cr
   R25BD \tab Number of Errant Soil Moisture Calibrated Delta-T at 25cm Observations \tab number of 30-minute observations \tab Number of errant 30-minute calibrated delta-t at 25cm observations. \cr
   R60BD \tab Number of Errant Soil Moisture Calibrated Delta-T at 60cm Observations \tab number of 30-minute observations \tab Number of errant 30-minute calibrated delta-t at 60cm observations. \cr
   R75BD \tab Number of Errant Soil Moisture Calibrated Delta-T at 75cm Observations \tab number of 30-minute observations \tab *Decommissioned March 2012. Number of errant 30-minute calibrated delta-t at 75cm observations. \cr
   RAIN \tab Rain \tab inches \tab Liquid precipitation measured each day.  Frozen precipitation cannot be recorded until it melts; therefore, precipitation from snow may not be recorded until several days after the snow event. \cr
   RBAD \tab Number of Errant 5-minute Rain Observations \tab number of 5-minute observations \tab Number of errant 5-minute rain observations each day. \cr
   RMAX \tab Maximum 5-minute Rainfall Rate \tab inches per hour \tab Highest 5-minute averaged rainfall rate each day. \cr
   RNUM \tab Number of 5-minute Rainy Periods \tab number of 5-minute observations \tab Number of 5-minute observations in which precipitation increased. Frozen precipitation cannot be recorded until it melts; therefore precipitation from snow may not be recorded until several days after the snow event. \cr
   S25AV \tab Average Temperature Under Native Vegetation at 25cm \tab degrees Celsius \tab Average of all 15-minute averaged soil temperature observations each day. This variable is only available after and including December 1, 2013. \cr
   S25BD \tab Number of Errant Temperature Under Native Vegetation at 25cm Observations \tab number of 15-minute observations \tab Number of errant 15-minute temperature under native vegetation at 25cm observations each day. This variable is only available after and including December 1, 2013. \cr
   S25MN \tab Minimum Temperature Under Native Vegetation at 25cm \tab degrees Celsius \tab Lowest 15-minute averaged soil temperature observation each day. This variable is only available after and including December 1, 2013. \cr
   S25MX \tab Maximum Temperature Under Native Vegetation at 25cm \tab degrees Celsius \tab Highest 15-minute averaged soil temperature observation each day. This variable is only available after and including December 1, 2013. \cr
   S25NO \tab Minimum Temperature Under Native Vegetation at 25cm Observation Number \tab 15-minute observation number \tab Daily 15-minute observation number that measured minimum temperature under native vegetation at 25cm each day. This variable is only available after and including December 1, 2013. \cr
   S25XO \tab Maximum Temperature Under Native Vegetation at 25cm Observation Number \tab 15-minute observation number \tab Daily 15-minute observation number that measured maximum temperature under native vegetation at 25cm each day. This variable is only available after and including December 1, 2013. \cr
   S3AV \tab Average Temperature Under Native Vegetation at 30cm \tab degrees Celsius \tab Average of all 15-minute averaged soil temperature observations each day. This variable is only available prior to December 1, 2013. \cr
   S3BD \tab Number of Errant Temperature Under Native Vegetation at 30cm Observations \tab number of 15-minute observations \tab Number of errant 15-minute temperature under native vegetation at 30cm observations each day. This variable is only available prior to December 1, 2013. \cr
   S3MN \tab Minimum Temperature Under Native Vegetation at 30cm \tab degrees Celsius \tab Lowest 15-minute averaged soil temperature observation each day. This variable is only available prior to December 1, 2013. \cr
   S3MNO \tab Minimum Temperature Under Native Vegetation at 30cm Observation Number \tab 15-minute observation number \tab Daily 15-minute observation number that measured minimum temperature under native vegetation at 30cm each day. This variable is only available prior to December 1, 2013. \cr
   S3MX \tab Maximum Temperature Under Native Vegetation at 30cm \tab degrees Celsius \tab Highest 15-minute averaged soil temperature observation each day. This variable is only available prior to December 1, 2013. \cr
   S3MXO \tab Maximum Temperature Under Native Vegetation at 30cm Observation Number \tab 15-minute observation number \tab Daily 15-minute observation number that measured maximum temperature under native vegetation at 30cm each day. This variable is only available prior to December 1, 2013. \cr
   S5AV \tab Average Temperature Under Native Vegetation at 5cm \tab degrees Celsius \tab Average of all 15-minute averaged soil temperature observations each day. \cr
   S5BD \tab Number of Errant Temperature Under Native Vegetation at 5cm Observations \tab number of 15-minute observations \tab Number of errant 15-minute temperature under native vegetation at 5cm observations each day. \cr
   S5MN \tab Minimum Temperature Under Native Vegetation at 5cm \tab degrees Celsius \tab Lowest 15-minute averaged soil temperature observation each day. \cr
   S5MNO \tab Minimum Temperature Under Native Vegetation at 5cm Observation Number \tab 15-minute observation number \tab Daily 15-minute observation number that measured minimum temperature under native vegetation at 5cm each day. \cr
   S5MX \tab Maximum Temperature Under Native Vegetation at 5cm \tab degrees Celsius \tab Highest 15-minute averaged soil temperature observation each day. \cr
   S5MXO \tab Maximum Temperature Under Native Vegetation at 5cm Observation Number \tab 15-minute observation number \tab Daily 15-minute observation number that measured maximum temperature under native vegetation at 5cm each day. \cr
   S60AV \tab Average Temperature Under Native Vegetation at 60cm \tab degrees Celsius \tab Average of all 15-minute averaged soil temperature observations each day. This variable is only available after and including December 1, 2013. \cr
   S60BD \tab Number of Errant Temperature Under Native Vegetation at 60cm Observations \tab number of 15-minute observations \tab Number of errant 15-minute temperature under native vegetation at 60cm observations each day. This variable is only available after and including December 1, 2013. \cr
   S60MN \tab Minimum Temperature Under Native Vegetation at 60cm \tab degrees Celsius \tab Lowest 15-minute averaged soil temperature observation each day. This variable is only available after and including December 1, 2013. \cr
   S60MX \tab Maximum Temperature Under Native Vegetation at 60cm \tab degrees Celsius \tab Highest 15-minute averaged soil temperature observation each day. This variable is only available after and including December 1, 2013. \cr
   S60NO \tab Minimum Temperature Under Native Vegetation at 60cm Observation Number \tab 15-minute observation number \tab Daily 15-minute observation number that measured minimum temperature under native vegetation at 60cm each day. This variable is only available after and including December 1, 2013. \cr
   S60XO \tab Maximum Temperature Under Native Vegetation at 60cm Observation Number \tab 15-minute observation number \tab Daily 15-minute observation number that measured maximum temperature under native vegetation at 60cm each day. This variable is only available after and including December 1, 2013. \cr
   SAVG \tab Average Temperature Under Native Vegetation at 10cm \tab degrees Celsius \tab Average of all 15-minute averaged soil temperature observations each day. \cr
   SBAD \tab Number of Errant Temperature Under Native Vegetation at 10cm Observations \tab number of 15-minute observations \tab Number of errant 15-minute temperature under native vegetation at 10cm observations each day. \cr
   SDFQ \tab Secondary Wind Direction Frequency \tab percentage \tab Frequency of observations in the given wind direction category. \cr
   SDIR \tab Secondary Wind Direction \tab 16-point cardinal direction \tab Second most common wind direction for the day based on 16-point compass heading. \cr
   SMAX \tab Maximum Temperature Under Native Vegetation at 10cm \tab degrees Celsius \tab Highest 15-minute averaged soil temperature observation each day. \cr
   SMAXO \tab Maximum Temperature Under Native Vegetation at 10cm Observation Number \tab 15-minute observation number \tab Daily 15-minute observation number that measured maximum temperature under native vegetation at 10cm each day. \cr
   SMIN \tab Minimum Temperature Under Native Vegetation at 10cm \tab degrees Celsius \tab Lowest 15-minute averaged soil temperature observation each day. \cr
   SMINO \tab Minimum Temperature Under Native Vegetation at 10cm Observation Number \tab 15-minute observation number \tab Daily 15-minute observation number that measured minimum temperature under native vegetation at 10cm each day. \cr
   STID \tab Station ID \tab  \tab Station ID \cr
   TAVG \tab Average Air Temperature \tab degrees Celsius \tab Average of all 5-minute averaged temperature observations each day. \cr
   TBAD \tab Number of Errant 1.5m Air Temperature Observations \tab number of 5-minute observations \tab Number of errant 5-minute averaged 1.5m air temperature observations each day. \cr
   TMAX \tab Maximum Daily Air Temperature \tab degrees Celsius \tab Highest 5-minute averaged temperature observation reported each day. \cr
   TMAXO \tab Maximum Daily Air Temperature Observation Number \tab 5-minute observation number \tab Daily observation number that measured highest 5-minute averaged 1.5 m air temperature each day. \cr
   TMIN \tab Minimum Daily Air Temperature \tab degrees Celsius \tab Lowest 5-minute averaged temperature observation reported each day. \cr
   TMINO \tab Minimum Daily Air Temperature Observation Number \tab 5-minute observation number \tab Daily observation number that measured lowest 5-minute averaged 1.5 m air temperature each day. \cr
   TR05 \tab Soil Moisture Calibrated Delta-T at 5cm \tab degrees Celsius \tab Calibrated change in temperature of soil over time after a heat pulse is introduced. Used to calculate soil water potential, fractional water index, or volumetric water. \cr
   TR25 \tab Soil Moisture Calibrated Delta-T at 25cm \tab degrees Celsius \tab Calibrated change in temperature of soil over time after a heat pulse is introduced. Used to calculate soil water potential, fractional water index, or volumetric water. \cr
   TR60 \tab Soil Moisture Calibrated Delta-T at 60cm \tab degrees Celsius \tab Calibrated change in temperature of soil over time after a heat pulse is introduced. Used to calculate soil water potential, fractional water index, or volumetric water. \cr
   TR75 \tab Soil Moisture Calibrated Delta-T at 75cm \tab degrees Celsius \tab *Decommissioned March 2012. Calibrated change in temperature of soil over time after a heat pulse is introduced. Used to calculate soil water potential, fractional water index, or volumetric water. \cr
   VDEF \tab Average Daily Vapor Deficit \tab millibars \tab Average of all 5-minute averaged vapor deficit estimates each day. \cr
   WBAD \tab Number of Errant Wind Speed Observations \tab number of 5-minute observations \tab Number of errant 5-minute 10m wind speed observations each day. \cr
   WCBAD \tab Number of Errant Wind Chill Observations \tab number of 5-minute observations \tab Number of errant 5-minute wind chill observations each day. \cr
   WCMN \tab Minimum Wind Chill Index Temperature \tab degrees Celsius \tab Lowest 5-minute averaged wind chill observation each day. Derived using 5-minute averaged air temperature and corresponding 5-minute averaged 10-m wind speed observation. \cr
   WCMNO \tab Minimum Daily Wind Chill Observation Number \tab 5-minute observation number \tab Daily observation number that measured lowest 5-minute averaged wind chill each day. \cr
   WDEV \tab Standard Deviation of Wind Speed at 10m \tab meters per second \tab Standard deviation of the wind speed at 10m during a 5-minute observation period. \cr
   WMAX \tab Maximum Wind Gust \tab meters per second \tab Highest 3-second wind speed measurement each day. \cr
   WMAXO \tab Maximum Wind Gust Observation Number \tab 5-minute observation number \tab Daily 5-minute observation number that measured maximum wind gust each day. \cr
   WSMN \tab Minimum Wind Speed \tab meters per second \tab Lowest 5-minute averaged 10m wind speed measurement each day. \cr
   WSMNO \tab Minimum Wind Speed Observation Number \tab 5-minute observation number \tab Daily 5-minute observation number that measured minimum wind speed at 10m each day. \cr
   WSMX \tab Maximum Wind Speed \tab meters per second \tab Highest 5-minute averaged 10m wind speed measurement each day. \cr
   WSMXO \tab Maximum Wind Speed Observation Number \tab 5-minute observation number \tab Daily 5-minute observation number that measured maximum wind speed at 10m each day. \cr
   WSPD \tab Average Wind Speed \tab meters per second \tab Average of all 5-minute wind speed observations each day. \cr
}
}
\description{
Produce a daily summary of Oklahoma Mesonet subdaily data
}
\examples{

\dontshow{
  mesonet_cache_dir <- mnet_test_cache(site_info = TRUE,
                                       mts_files = TRUE,
                                       rds_files = TRUE)
  previous_options <- options(.mesonet_cache = mesonet_cache_dir)
}

# Retrieve some data to summarize:
mesonet_data <- mnet_retrieve(stid = "ACME",
                              start_date = "1994-01-02",
                              end_date = "1994-01-03")

# Interval is 1 day by default:
mnet_summarize(mesonet_data)

# Summarize to hourly:
mnet_summarize(mesonet_data,
               interval = "1 hour")

\dontshow{
  unlink(mesonet_cache_dir, recursive = TRUE)
  options(previous_options)
}

}
