% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_normalization.R
\name{denormalize}
\alias{denormalize}
\title{Denormalize}
\usage{
denormalize(x, min, max)
}
\arguments{
\item{x}{Numeric vector that has been normalized (values is between 0 and 1).}

\item{min}{The minimum value of the original data.}

\item{max}{The maximum value of the original data.}
}
\value{
A numeric vector already converted to original scale.
}
\description{
Convert normalized data back to original scale using given min and max.
}
\examples{
# Example of the original data
original_data <- c(10, 20, 30, 40, 50)

# Data being normalized
normalized_data <- (original_data - min(original_data)) /
                   (max(original_data) - min(original_data))

# Denormalization function use to change value to the original
denormalize(normalized_data, min(original_data), max(original_data))

}
