% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dat.BCT2009}
\alias{dat.BCT2009}
\title{A subset of data from Michie et al. (2009)}
\format{
A data frame of 106 interventions with five motivation-enhancing behavior change techniques (BCTs).
\itemize{
  \item study: The name of the intervention.
  \item g: The effect size of each intervention.
  \item vi: The sampling variance of the effect size.
  \item T1: Indicating whether the BCT1 "Provide information about
  behavior-health link" was used by the intervention. "1" for used
  and "0" for not used.
  \item T2: Indicating whether the BCT2 "Provide information on consequences"
   was used by the intervention. "1" for used
  and "0" for not used.
  \item T3: Indicating whether the BCT3 "Provide information about other's approval"
   was used by the intervention. "1" for used
  and "0" for not used.
  \item T4: Indicating whether the BCT4 "Prompt intention formation"
   was used by the intervention. "1" for used
  and "0" for not used.
  \item T25: Indicating whether the BCT25 " Motivational interviewing"
   was used by the intervention. "1" for used
  and "0" for not used.


  }
}
\usage{
data(dat.BCT2009)
}
\description{
The complete data consist of 101 studies reporting 122 interventions targeted at physical activity and healthy eating.
In this subset of the data, the interventions that include at least one
of the motivation-enhancing behaviour change techniques (BCTs) were selected (N = 106).
}
\details{
IMPORTANT: for questions about these data contact Juan Claramunt: j.claramunt.gonzalez@fsw.leidenuniv.nl.
}
\references{
If you use these data, please refer to: Michie, S., Abraham, C., Whittington, C., McAteer, J., & Gupta, S. (2009). Effective techniques in healthy eating and physical activity interventions: a meta-regression. \emph{Health Psychology, 28(6)}, 690.

An application of (a preliminary version of) meta-CART to this data set is given in: Dusseldorp, E., Van Genugten, L., van Buuren, S., Verheijden, M. W., & van Empelen, P. (2014). Combinations of techniques that effectively change health behavior: Evidence from Meta-CART analysis. \emph{Health Psychology, 33(12)}, 1530.
}
\keyword{data}
