% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimaandpaths.R
\name{fespoint.hillsfile}
\alias{fespoint.hillsfile}
\title{Calculate free energy at given point in the CV space}
\usage{
\method{fespoint}{hillsfile}(hills, coord = NULL, imin = 1,
  imax = NULL, verb = T)
}
\arguments{
\item{hills}{hillsfile object.}

\item{coord}{coordinates of the point in the CV space.}

\item{imin}{index of a hill from which calculation of difference
starts (default 1).}

\item{imax}{index of a hill from which summation stops (default the rest of hills).}

\item{verb}{if TRUE, the output is verbose (default TRUE).}
}
\description{
`fespoint.hillsfile` calculates free energy at given point in the CV space 'coord'.
Hills are summed from 'imin' to `imax`. Printed output can be suppressed by setting
'verb' to TRUE.
}
\examples{
fespoint(acealanme, c(0,0), imax=5000)
}
