% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WOA.Algorithm.R
\name{WOA}
\alias{WOA}
\title{Optimization using Whale Optimization Algorithm}
\usage{
WOA(FUN, optimType = "MIN", numVar, numPopulation = 40,
  maxIter = 500, rangeVar)
}
\arguments{
\item{FUN}{an objective function or cost function,}

\item{optimType}{a string value that represent the type of optimization.
There are two option for this arguments: \code{"MIN"} and \code{"MAX"}.
The default value is \code{"MIN"}, which the function will do minimization.
Otherwise, you can use \code{"MAX"} for maximization problem.
The default value is \code{"MIN"}.}

\item{numVar}{a positive integer to determine the number variables.}

\item{numPopulation}{a positive integer to determine the number populations. The default value is 40.}

\item{maxIter}{a positive integer to determine the maximum number of iterations. The default value is 500.}

\item{rangeVar}{a matrix (\eqn{2 \times n}) containing the range of variables,
where \eqn{n} is the number of variables, and first and second rows
are the lower bound (minimum) and upper bound (maximum) values, respectively.
If all variable have equal upper bound, you can define \code{rangeVar} as
matrix (\eqn{2 \times 1}).}
}
\value{
\code{Vector [v1, v2, ..., vn]} where \code{n} is number variable
        and \code{vn} is value of \code{n-th} variable.
}
\description{
This is the internal function that implements Whale Optimization
Algorithm. It is used to solve continuous optimization tasks.
Users do not need to call it directly,
but just use \code{\link{metaOpt}}.
}
\details{
This algorithm was proposed by (Mirjalili, 2016), which mimics the
social behavior of humpback whales. The algorithm is inspired by the
bubble-net hunting strategy.

In order to find the optimal solution, the algorithm follow the following steps.
\itemize{
\item Initialization: Initialize the first population of whale randomly,
      calculate the fitness of whale and find the best whale position as the
      best position obtained so far.
\item Update Whale Position: Update the whale position using bubble-net hunting
      strategy. The whale position will depend on the best whale position obtained so far.
      Otherwise random whale choosen if the specific condition meet.
\item Update the best position if there are new whale that have better fitness
\item Check termination criteria, if termination criterion is satisfied, return the
      best position as the optimal solution for given problem. Otherwise, back to Update Whale Position steps.
}
}
\examples{
##################################
## Optimizing the sphere function

# define sphere function as objective function
sphere <- function(x){
    return(sum(x^2))
}

## Define parameter
numVar <- 5
rangeVar <- matrix(c(-10,10), nrow=2)

## calculate the optimum solution using Ant Lion Optimizer
resultWOA <- WOA(sphere, optimType="MIN", numVar, numPopulation=20,
                 maxIter=100, rangeVar)

## calculate the optimum value using sphere function
optimum.value <- sphere(resultWOA)

}
\references{
Seyedali Mirjalili, Andrew Lewis, The Whale Optimization Algorithm,
Advances in Engineering Software, Volume 95, 2016, Pages 51-67,
ISSN 0965-9978, https://doi.org/10.1016/j.advengsoft.2016.01.008
}
\seealso{
\code{\link{metaOpt}}
}
