% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{mean_dist_to}
\alias{mean_dist_to}
\title{Mean minimum distance}
\usage{
mean_dist_to(target, squared = TRUE)
}
\arguments{
\item{target}{A \code{data.frame} with all numeric columns.}

\item{squared}{Logical indicating whether to compute the mean squared
distance (if \code{TRUE}) or the mean distance.}
}
\value{
A function that takes a \code{data.frame} with the same number of columns as
\code{target} and then returns the mean minimum distance between them.
}
\description{
Creates a function to get the mean minimum distance between two sets of points.
}
\examples{
target <- data.frame(x = rnorm(100), y = rnorm(100))
data <- data.frame(x = rnorm(100), y = rnorm(100))
distance <- mean_dist_to(target)
distance(data)

}
\seealso{
Other helper functions: 
\code{\link{delayed_with}()},
\code{\link{densify}()},
\code{\link{draw_data}()},
\code{\link{mean_dist_to_sf}()},
\code{\link{mean_self_proximity}()},
\code{\link{moments_n}()},
\code{\link{truncate_to}()}
}
\concept{helper functions}
