% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.compare.R
\name{taxa.compare}
\alias{taxa.compare}
\title{Compare taxa relative abundance}
\usage{
taxa.compare(
  taxtab,
  propmed.rel = "gamlss",
  transform = "none",
  zeroreplace.method = "none",
  comvar,
  adjustvar,
  personid = "personid",
  longitudinal = "yes",
  percent.filter = 0.05,
  relabund.filter = 5e-05,
  p.adjust.method = "fdr"
)
}
\arguments{
\item{taxtab}{taxa relative abundance table (already merged to mapping file) from phylum to species or any preferred highest taxa level.}

\item{propmed.rel}{statistical method for comparing relative abundance. Options are "lm" for LM/LMEM or "gamlss" for GAMLSS with BEZI family.}

\item{transform}{transformation of relative abundance data. Options are "none" for no transformation, "gmpr" for Geometric Mean of Pairwise Ratios (GMPR) normalization, "asin.sqrt" for arcsine transformation, "logit" for logit transformation, "clr" for centered log ratio transformation. Default is "none".}

\item{zeroreplace.method}{Method for zero replacement implemented in R package *zCompositions*. Options are "none" for no replacement, "multKM" for Multiplicative Kaplan-Meier smoothing spline (KMSS) replacement, "multLN" for Multiplicative lognormal replacement, "multRepl" for Multiplicative simple replacement, "lrEM" for Log-ratio EM algorithm, "lrDA" for Log-ratio DA algorithm. Default is "none".}

\item{comvar}{main variable for comparison}

\item{adjustvar}{variables to be adjusted.}

\item{personid}{name of variable for person id (applicable for longitudinal data)}

\item{longitudinal}{whether data is longitudinal? Options are "yes" or "no". Default is "yes".}

\item{percent.filter}{prevalence threshold (the percentage of number of samples the taxa/pathway available). Default is 0.05.}

\item{relabund.filter}{relative abundance threshold (the minimum of the average relative abundance for a taxa/pathway to be retained). Default is 0.00005.}

\item{p.adjust.method}{method for multiple testing adjustment. Options are those of the p.adjust.methods of stats:: p.adjust function. Default for this function is "fdr".}
}
\value{
matrice of coefficients, standard errors, p-values and multiple testing adjusted p-values of all variables in the models.
}
\description{
This function compares taxa relative abundance summary tables at all levels between groups using GAMLSS with BEZI or Linear/Linear Mixed Effect models (LM/LMEM) after filtering (using prevalence and relative abundance thresholds).
}
\examples{
#Load summary tables of bacterial taxa relative abundance from Bangladesh data
data(taxtab6)
tab6<-as.data.frame(taxtab6)
tl<-colnames(taxtab6)[grep("k__bacteria.p__fusobacteria",colnames(taxtab6))]
taxacom.ex<-taxa.compare(taxtab=tab6[,c("personid","x.sampleid","bf","age.sample",tl)],
propmed.rel="gamlss",comvar="bf",adjustvar="age.sample",
longitudinal="yes",p.adjust.method="fdr")
}
\keyword{abundance}
\keyword{comparison}
\keyword{taxa}
