% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.mean.plot.R
\name{taxa.mean.plot}
\alias{taxa.mean.plot}
\title{Plot mean taxa abundance}
\usage{
taxa.mean.plot(
  tabmean,
  sumvar = "taxa",
  tax.select = "none",
  tax.lev = "l2",
  comvar,
  groupvar,
  mean.filter = 0.005,
  pallete.by.phylum = FALSE,
  show.taxname = "full",
  legend.position = "right",
  xlab = "",
  ylab = "Relative abundance"
)
}
\arguments{
\item{tabmean}{table of mean abundance generated from taxa.meansdn.}

\item{sumvar}{variable to be plotted. Options are c("taxa","path"). Default is "taxa"}

\item{tax.select}{list of selected taxa/pathways to be plotted. Default is "none" or plot all taxa/pathways.}

\item{tax.lev}{taxa level to be visualized. Options are from "l2" (phylum) to "l7" (species). Default is "l2". If sumvar="path", all pathways will be visualized.}

\item{comvar}{main variable for comparison.}

\item{groupvar}{variable for stratifying.}

\item{mean.filter}{mean abundance filtering threshold (only plot those with mean abundance>threshold and plot all those with mean abundance <threshold as "other").}

\item{pallete.by.phylum}{whether each pallete of color for each phylum. Default is FALSE (plot distinc colors).}

\item{show.taxname}{whether show "full" taxa name or "short" name. Default is "full".}

\item{legend.position}{position of legend. Options are c("right", "left","bottom","top","none") as in ggplot2. Default is "right".}

\item{xlab}{label for x-axis. Default is "Chronological age (month)".}

\item{ylab}{label for y-axis. Default is "Relative abundance".}
}
\value{
a list of ggplot2 object and list of taxa/pathways plotted (those with mean abundance >mean.filter).
}
\description{
This function visualize mean relative abundance by group as stacked plots.
}
\examples{
#Load summary tables of bacterial taxa relative abundance from Bangladesh data
data(taxtab6)
taxlist.rm<-taxa.filter(taxtab=taxtab6, percent.filter = 0.05, relabund.filter = 0.00005)
taxa.meansdn.rm<-taxa.meansdn(taxtab=taxtab6,sumvar="bf",groupvar="age.sample")
taxa.meansdn.rm<-taxa.meansdn.rm[taxa.meansdn.rm$bf!="No_BF",]
taxa.meansdn.rm$bf<-gdata::drop.levels(taxa.meansdn.rm$bf,reorder=FALSE)
#phylum
p.bf.l2<-taxa.mean.plot(tabmean=taxa.meansdn.rm, tax.lev="l2",
comvar="bf", groupvar="age.sample",mean.filter=0.005, show.taxname="short")
p.bf.l2$p
}
\keyword{abundance}
\keyword{mean}
\keyword{plot.}
\keyword{taxa}
