% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_ammi.R
\name{cv_ammi}
\alias{cv_ammi}
\title{Cross-validation procedure}
\usage{
cv_ammi(
  .data,
  env,
  gen,
  rep,
  resp,
  block = NULL,
  naxis = 2,
  nboot = 200,
  design = "RCBD",
  verbose = TRUE
)
}
\arguments{
\item{.data}{The dataset containing the columns related to Environments,
Genotypes, replication/block and response variable(s).}

\item{env}{The name of the column that contains the levels of the
environments.}

\item{gen}{The name of the column that contains the levels of the genotypes.}

\item{rep}{The name of the column that contains the levels of the
replications/blocks. \strong{AT LEAST THREE REPLICATES ARE REQUIRED TO
PERFORM THE CROSS-VALIDATION}.}

\item{resp}{The response variable.}

\item{block}{Defaults to \code{NULL}. In this case, a randomized complete
block design is considered. If block is informed, then a resolvable
alpha-lattice design (Patterson and Williams, 1976) is employed.
\strong{All effects, except the error, are assumed to be fixed.}}

\item{naxis}{The number of axis to be considered for estimation of GE
effects.}

\item{nboot}{The number of resamples to be used in the cross-validation.
Defaults to 200.}

\item{design}{The experimental design. Defaults to \code{RCBD} (Randomized
complete Block Design). For Completely Randomized Designs inform
\code{design = 'CRD'}.}

\item{verbose}{A logical argument to define if a progress bar is shown.
Default is \code{TRUE}.}
}
\value{
An object of class \code{cv_ammi} with the following items: *
\strong{RMSPD}: A vector with nboot-estimates of the Root Mean Squared
Prediction Difference between predicted and validating data.
\itemize{
\item \strong{RMSPDmean}: The mean of RMSPDmean estimates.
\item \strong{Estimated}: A data frame that contain the values (predicted,
observed, validation) of the last loop.
\item \strong{Modeling}: The dataset used as modeling data in the last loop
\item \strong{Testing}: The dataset used as testing data in the last loop.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Cross-validation for estimation of AMMI models

THe original dataset is split into two datasets: training set and validation
set. The 'training' set has all combinations (genotype x environment) with
N-1 replications. The 'validation' set has the remaining replication. The
splitting of the dataset into modeling and validation sets depends on the
design informed. For Completely Randomized Block Design (default), and
alpha-lattice design (declaring \code{block} arguments), complete replicates
are selected within environments. The remained replicate serves as validation
data. If \code{design = 'RCD'} is informed, completely randomly samples are
made for each genotype-by-environment combination (Olivoto et al. 2019). The
estimated values considering \code{naxis}-Interaction Principal Component
Axis are compared with the 'validation' data. The Root Mean Square Prediction
Difference (RMSPD) is computed. At the end of boots, a list is returned.

\strong{IMPORTANT:} If the data set is unbalanced (i.e., any genotype missing
in any environment) the function will return an error. An error is also
observed if any combination of genotype-environment has a different number of
replications than observed in the trial.
}
\examples{

\donttest{
library(metan)
model <- cv_ammi(data_ge,
                env = ENV,
                gen = GEN,
                rep = REP,
                resp = GY,
                nboot = 5,
                naxis = 2)
}


}
\references{
Olivoto, T., A.D.C. Lúcio, J.A.G. da silva, V.S. Marchioro,
V.Q. de Souza, and E. Jost. 2019. Mean performance and stability in
multi-environment trials I: Combining features of AMMI and BLUP techniques.
Agron. J. 111:2949-2960.
\doi{10.2134/agronj2019.03.0220}

Patterson, H.D., and E.R. Williams. 1976. A new class of
resolvable incomplete block designs. Biometrika 63:83-92.
}
\seealso{
\code{\link[=cv_ammif]{cv_ammif()}}, \code{\link[=cv_blup]{cv_blup()}}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
