% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mps.R
\name{mps}
\alias{mps}
\title{Mean performance and stability in multi-environment trials}
\usage{
mps(
  .data,
  env,
  gen,
  rep,
  resp,
  block = NULL,
  by = NULL,
  random = "gen",
  performance = c("blupg", "blueg"),
  stability = "waasb",
  ideotype_mper = NULL,
  ideotype_stab = NULL,
  wmper = NULL,
  verbose = TRUE
)
}
\arguments{
\item{.data}{The dataset containing the columns related to Environments,
Genotypes, replication/block and response variable(s).}

\item{env}{The name of the column that contains the levels of the
environments.}

\item{gen}{The name of the column that contains the levels of the genotypes.}

\item{rep}{The name of the column that contains the levels of the
replications/blocks.}

\item{resp}{The response variable(s). To analyze multiple variables in a
single procedure a vector of variables may be used. For example \code{resp = c(var1, var2, var3)}.}

\item{block}{Defaults to \code{NULL}. In this case, a randomized complete
block design is considered. If block is informed, then an alpha-lattice
design is employed considering block as random to make use of inter-block
information, whereas the complete replicate effect is always taken as
fixed, as no inter-replicate information was to be recovered (Mohring et
al., 2015).}

\item{by}{One variable (factor) to compute the function by. It is a shortcut
to \code{\link[dplyr:group_by]{dplyr::group_by()}}.This is especially useful, for example, when the
researcher want to analyze environments within mega-environments. In this
case, an object of class mps_grouped is returned.}

\item{random}{The effects of the model assumed to be random. Defaults to
\code{random = "gen"}. See \code{\link[=gamem_met]{gamem_met()}} to see the random effects assumed
depending on the experimental design of the trials.}

\item{performance}{Wich considers as mean performance. Either \code{blupg} (for
Best Linear Unbiased Prediction) or \code{blueg} (for Best Linear Unbiased
Estimation)}

\item{stability}{The stability method. One of the following:
\itemize{
\item \code{"waasb"} The weighted average of absolute scores (Olivoto et al. 2019).
\item \code{"ecovalence"} The Wricke's ecovalence (Wricke, 1965).
\item \code{"Shukla"} The Shukla's stability variance parameter (Shukla, 1972).
\item \code{"hmgv"} The harmonic mean of genotypic values (Resende, 2007).
\item \code{"s2di"} The deviations from the Eberhart and Russell regression (Eberhart
and Russell, 1966).
\item \code{"r2"} The determination coefficient of the Eberhart and Russell regression
(Eberhart and Russell, 1966)..
\item \code{"rmse"} The root mean squared error of the Eberhart and Russell regression
(Eberhart and Russell, 1966).
\item \code{"wi"} Annicchiarico's genotypic confidence index (Annicchiarico, 1992).
\item \code{"polar"} Power Law Residuals as yield stability index (Doring et al.,
2015).
\item \code{"acv"} Adjusted Coefficient of Variation (Doring and Reckling, 2018)
\item \code{"pi"} Lin e Binns' superiority index (Lin and Binns, 1988).
\item \code{"gai"} Geometric adaptability index (Mohammadi and Amri, 2008).
\item \verb{"s1", "s2", "s3", and "s6"} Huehn's stability statistics (Huehn, 1979).
\item \verb{"n1", "n2", "n3", and "n4"} Thennarasu's stability statistics (Thennarasu,
1995).
\item \verb{"asv", "ev", "za", and "waas"} AMMI-based stability indexes (see
\code{\link[=ammi_indexes]{ammi_indexes()}}).
}}

\item{ideotype_mper, ideotype_stab}{The new maximum value after rescaling the
response variable/stability index. By default, all variables in \code{resp} are
rescaled so that de maximum value is 100 and the minimum value is 0 (i.e.,
\code{ideotype_mper = NULL} and \code{ideotype_stab = NULL}). It must be a character
vector of the same length of \code{resp} if rescaling is assumed to be different
across variables, e.g., if for the first variable smaller values are better
and for the second one, higher values are better, then \code{ideotype_mper = c("l, h")} must be used. For stability index in which lower values are
better, use \code{ideotype_stab = "l"}. Character value of length 1 will be
recycled with a warning message.}

\item{wmper}{The weight for the mean performance. By default, all variables
in \code{resp} have equal weights for mean performance and stability (i.e.,
\code{wmper = 50}). It must be a numeric vector of the same length of \code{resp} to
assign different weights across variables, e.g., if for the first variable
equal weights for mean performance and stability are assumed and for the
second one, a higher weight for mean performance (e.g. 65) is assumed, then
\code{wmper = c(50, 65)} must be used. Numeric value of length 1 will be
recycled with a warning message.}

\item{verbose}{Logical argument. If \code{verbose = FALSE} the code will run
silently.}
}
\value{
An object of class \code{mps} with the following items.
\itemize{
\item \code{observed}: The observed value on a genotype-mean basis.
\item \code{performance}: The performance for genotypes (BLUPs or BLUEs)
\item \code{performance_res}: The rescaled values of genotype's performance,
considering \code{ideotype_mper}.
\item \code{stability}: The stability for genotypes, chosen with argument \code{stability}.
\item \code{stability_res}: The rescaled values of genotype's stability, considering
\code{ideotype_stab}.
\item \code{mps_ind}: The mean performance and stability for the traits.
\item \code{h2}: The broad-sense heritability for the traits.
\item \code{perf_method}: The method for measuring genotype's performance.
\item \code{wmper}: The weight for the mean performance.
\item \code{sense_mper}: The goal for genotype's performance (\code{l} = lower, \code{h} = higher).
\item \code{stab_method}: The method for measuring genotype's stability.
\item \code{wstab}: The weight for the mean stability.
\item \code{sense_stab}: The goal for genotype's stability (\code{l} = lower, \code{h} = higher).
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function implements the weighting method between mean performance and
stability (Olivoto et al., 2019) considering different parametric and
non-parametric stability indexes.
}
\examples{
\donttest{
library(metan)
# The same approach as mtsi()
# mean performance and stability for GY and HM
# mean performance: The genotype's BLUP
# stability: the WAASB index (lower is better)
# weights: equal for mean performance and stability

model <-
mps(data_ge,
    env = ENV,
    gen = GEN,
    rep = REP,
    resp = everything())

# The mean performance and stability after rescaling
model$mps_ind
}
}
\references{
Annicchiarico, P. 1992. Cultivar adaptation and recommendation from alfalfa
trials in Northern Italy. J. Genet. Breed. 46:269-278.

Doring, T.F., S. Knapp, and J.E. Cohen. 2015. Taylor's power law and the
stability of crop yields. F. Crop. Res. 183: 294-302.
\doi{10.1016/j.fcr.2015.08.005}

Doring, T.F., and M. Reckling. 2018. Detecting global trends of cereal yield
stability by adjusting the coefficient of variation. Eur. J. Agron. 99:
30-36. \doi{10.1016/j.eja.2018.06.007}

Eberhart, S.A., and W.A. Russell. 1966. Stability parameters for comparing Varieties.
Crop Sci. 6:36-40. \doi{10.2135/cropsci1966.0011183X000600010011x}

Huehn, V.M. 1979. Beitrage zur erfassung der phanotypischen stabilitat. EDV
Med. Biol. 10:112.

Lin, C.S., and M.R. Binns. 1988. A superiority measure of cultivar
performance for cultivar x location data. Can. J. Plant Sci. 68:193-198.
\doi{10.4141/cjps88-018}

Mohammadi, R., & Amri, A. (2008). Comparison of parametric and non-parametric
methods for selecting stable and adapted durum wheat genotypes in variable
environments. Euphytica, 159(3), 419-432. \doi{10.1007/s10681-007-9600-6}

Olivoto, T., A.D.C. Lúcio, J.A.G. da silva, V.S. Marchioro, V.Q. de
Souza, and E. Jost. 2019. Mean performance and stability in multi-environment
trials I: Combining features of AMMI and BLUP techniques. Agron. J.
\doi{10.2134/agronj2019.03.0220}

Resende MDV (2007) Matematica e estatistica na analise de experimentos e no
melhoramento genetico. Embrapa Florestas, Colombo

Shukla, G.K. 1972. Some statistical aspects of partitioning
genotype-environmental components of variability. Heredity. 29:238-245.
\doi{10.1038/hdy.1972.87}

Thennarasu, K. 1995. On certain nonparametric procedures for studying
genotype x environment interactions and yield stability. Ph.D. thesis. P.J.
School, IARI, New Delhi, India.

Wricke, G. 1965. Zur berechnung der okovalenz bei sommerweizen und hafer. Z.
Pflanzenzuchtg 52:127-138.
}
\seealso{
\code{\link[=mtsi]{mtsi()}}, \code{\link[=mtmps]{mtmps()}}, \code{\link[=mgidi]{mgidi()}}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
