% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_plot_intensities.R
\name{plot_intensities}
\alias{plot_intensities}
\title{plot_intensities}
\usage{
plot_intensities(
  spectral_count_object,
  target_variable,
  image_title = NULL,
  force = FALSE
)
}
\arguments{
\item{spectral_count_object}{List defined as "spectral_count_object" 
containing dataframes with abundance expressed as spectral counts 
from peptides, subgroups, groups or taxonomic levels. The format of 
this object is similar to that generated from the functions 
"getsc_specific" and "crumble_taxonomy".}

\item{target_variable}{Character indicating the name of one column from 
metadata, the column must contain the conditions to be displayed.}

\item{image_title}{Character indicating the title to be displayed 
in the generated image.}

\item{force}{Logic value set at FALSE by default in order to ask
for permission to create a pdf file in the workstation of the user.}
}
\value{
Violin plots (pdf) indicating the spectral counts of the different 
   levels (peptides, subgroups, groups or taxonomic entities) per sample 
   or condition.
}
\description{
Draws violin plots containing the abundance intensities expressed as 
spectral counts per level (peptides, subgroups, groups or taxonomic entities) 
in provided samples or conditions from a "spectral_count_object". If the 
provided conditions have several replicates the mean value is taken into account.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}

data(fecal_waters)
plot_intensities(fecal_waters, "SC_name", "Title to display inside the plot")

data(species_fw)
plot_intensities(species_fw, "Condition", "Abundance per condition")

\dontshow{setwd(.old_wd)}
}
