% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codelists.R
\name{create_cat_var}
\alias{create_cat_var}
\title{Create Categorical Variable from Codelist}
\usage{
create_cat_var(
  data,
  metacore,
  ref_var,
  grp_var,
  num_grp_var = NULL,
  create_from_decode = FALSE,
  strict = TRUE
)
}
\arguments{
\item{data}{Dataset with reference variable in it}

\item{metacore}{A metacore object to get the codelist from. If the
variable has different codelists for different datasets the metacore object
will need to be subsetted using \code{select_dataset} from the metacore package.}

\item{ref_var}{Name of variable to be used as the reference i.e AGE when
creating AGEGR1}

\item{grp_var}{Name of the new grouped variable}

\item{num_grp_var}{Name of the new numeric decode for the grouped variable.
This is optional if no value given no variable will be created}

\item{create_from_decode}{Sets the \code{decode} column of the codelist as the column
from which the variable will be created. By default the column is \code{code}.}

\item{strict}{A logical value indicating whether to perform strict checking
against the codelist. If \code{TRUE} will issue a warning if values in the \code{ref_var}
column do not fit into the group definitions for the codelist in \code{grp_var}.
If \code{FALSE} no warning is issued and values not defined by the codelist will
likely result in \code{NA} results.}
}
\value{
dataset with new column added
}
\description{
Using the grouping from either the \code{decode_var} or \code{code_var} and a reference
variable (\code{ref_var}) it will create a categorical variable and the numeric
version of that categorical variable.
}
\examples{
library(metacore)
library(haven)
library(dplyr)
load(metacore_example("pilot_ADaM.rda"))
spec <- metacore \%>\% select_dataset("ADSL")
dm <- read_xpt(metatools_example("dm.xpt")) \%>\%
  select(USUBJID, AGE)
# Grouping Column Only
create_cat_var(dm, spec, AGE, AGEGR1)
# Grouping Column and Numeric Decode
create_cat_var(dm, spec, AGE, AGEGR1, AGEGR1N)
}
