% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/residuals.meteRelat.R
\name{residuals.meteRelat}
\alias{residuals.meteRelat}
\title{Compute residuals between METE predictions and date of a meteRelat object}
\usage{
\method{residuals}{meteRelat}(object, ...)
}
\arguments{
\item{object}{a \code{meteRelat} object}

\item{...}{arguments to be passed}
}
\value{
a numeic vector giving residuals for each data point
}
\description{
\code{residuals.meteRelat} computes residuals between METE predictions and
data of a meteDist object
}
\details{
See Examples. Typically not called directly by the user and rather used for
calculating the mean square error with \code{mse.meteRelat}.
}
\examples{
data(arth)
esf1 <- meteESF(spp=arth$spp,
                abund=arth$count,
                power=arth$mass^(.75),
                minE=min(arth$mass^(.75)))
ebar1 <- ebar(esf1)
residuals(ebar1)
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}
\seealso{
\code{mse.meteDist}
}

