% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vartymetric.R
\name{thselect.vmetric}
\alias{thselect.vmetric}
\title{Metric-based threshold selection}
\usage{
thselect.vmetric(
  xdat,
  thresh,
  B = 199L,
  type = c("eqd", "exp", "qq", "pp"),
  dist = c("l1", "l2"),
  uq = FALSE,
  neval = 1000L,
  level = 0.95,
  plot = FALSE,
  ...
)
}
\arguments{
\item{xdat}{vector of observations}

\item{thresh}{vector of thresholds}

\item{B}{number of bootstrap replications}

\item{type}{string indicating scale, either \code{exp} for exponential quantile-quantile plot  as in Varty et al. (2021) or \code{pp} for probability-probability plot (uniform). The method \code{qq} or expected quantile discrepancy (\code{eqd}) corresponds to Murphy et al. (2024) with the quantiles on the generalized Pareto scale.}

\item{dist}{string indicating norm, either \code{l1} for absolute error or \code{l2} for quadratic error}

\item{uq}{logical; if \code{TRUE}, generate bootstrap samples accounting for the sampling distribution of parameters}

\item{neval}{number of points at which to estimate the metric. Default to 1000L}

\item{level}{level of symmetric confidence interval. Default to 0.95}

\item{plot}{logical; if \code{TRUE}, returns a plot}

\item{...}{additional arguments for backward compatibility}
}
\value{
an invisible list with components
\itemize{
\item \code{thresh}: scalar threshold minimizing criterion
\item \code{thresh0}: vector of candidate thresholds
\item \code{metric}: value of the metric criterion evaluated at each threshold
\item \code{type}: argument \code{type}
\item \code{dist}: argument \code{dist},
\item \code{level}: level of confidence interval, from \code{level}
}
}
\description{
Adaptation of Varty et al.'s metric-based threshold
automated diagnostic for the  independent and identically distributed case with no rounding.
}
\details{
The algorithm proceeds by first computing the maximum
likelihood algorithm and then simulating datasets from
replication with parameters drawn from a bivariate normal
approximation to the maximum likelihood estimator distribution.

For each bootstrap sample, we refit the
 model and convert the quantiles to
 exponential or uniform variates.
The mean absolute or mean squared distance
is calculated on these. The threshold
returned is the one with the lowest value
of the metric.
}
\examples{
xdat <- rexp(1000, rate = 1/2)
thresh <- quantile(xdat, prob = c(0.25,0.5, 0.75))
thv <- thselect.vmetric(xdat, thresh, B = 99)
plot(thv)
print(thv)
}
\references{
Varty, Z. and J.A. Tawn and P.M. Atkinson and S. Bierman (2021+), Inference for extreme earthquake magnitudes accounting for a time-varying measurement process.

Murphy, C., Tawn, J. A., & Varty, Z. (2024). \emph{Automated Threshold Selection and Associated Inference Uncertainty for Univariate Extremes}. Technometrics, 67(\bold{2}), 215–224. <doi:10.1080/00401706.2024.2421744>
}
