% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generation_transformations.R
\name{generate_transformations_fp}
\alias{generate_transformations_fp}
\alias{generate_transformations_acd}
\title{Function to generate all requested FP transformations for a single variable}
\usage{
generate_transformations_fp(x, degree, powers)

generate_transformations_acd(x, degree, powers)
}
\arguments{
\item{x}{a numeric vector of length nobs assumed to have been shifted and
scaled.}

\item{degree}{numeric indicating the degree of FPs. Assumed to be 2 for acd
transformation.}

\item{powers}{a vector of allowed FP powers.}
}
\value{
A list with two entries:
\itemize{
\item \code{data}: a list with length equal to the number of possible FPs for the
variable of interest. Each entry is a matrix with degree many columns,
and nobs observations comprising the FP transformed input variable.
For example, for degree = 2 and nobs = 10, each entry is a 10 x 2 matrix.
Values are not centered. If \code{degree = 0}, the single entry has a single
column.
\item \code{powers}: the associated FP powers for each entry in data.
}
}
\description{
Function to generate all requested FP transformations for a single variable
}
\details{
Any FP transformation is given by a vector of powers, e.g. (p1, p2) for
degree 2. These correspond to powers x^p1 and x^p2. Thus, we only need to
consider combinations of all values in \code{powers}, since order of the entries
does not matter. See \code{\link[=generate_powers_fp]{generate_powers_fp()}}.
A special case are repeated powers, i.e. p1 = p2. In this case, the repeated
entries are multiplied by log(x) (see \code{\link[=transform_vector_fp]{transform_vector_fp()}}).

When the ACD transformation is requested, then all pairs of length 2
are considered, i.e. 64. See \code{\link[=generate_powers_acd]{generate_powers_acd()}}.

If \code{degree = 0} then these functions return the data unchanged for fp,
or simply the acd transformation of the input variable, i.e. in both cases
the power is set to 1 (linear).
}
\section{Functions}{
\itemize{
\item \code{generate_transformations_acd()}: Function to generate acd transformations.

}}
